package com.elitesland.yst.production.aftersale.model.vo;

import com.elitesland.yst.production.aftersale.model.entity.MaintainCardInfoDO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Context:
 * @title: VehicleThreePackageRespVO
 * @Author： 郑杰
 * @Date: 2023/2/14 15:29
 */
@Data
@ApiModel(description = "根据车主id查询车辆三包返回数据")
public class CarOwnerMaintainCardVO implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;
    
    @ApiModelProperty(value = "车架号")
    private String vehicleNo;
    
    @ApiModelProperty(value = "车辆名称")
    private String carName;
    
    @ApiModelProperty("车型")
    private String vehicleType;

    @ApiModelProperty("车辆规格")
    private String vehicleSpecs;

    @ApiModelProperty("车辆颜色")
    private String vehicleColor;

    @ApiModelProperty(value = "配件三包信息集合")
    private List<MaintainCardInfoDO> maintainCardInfoS;
}
