/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.controller.pc;

import com.elitescloud.boot.excel.common.ExportExcelService;
import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerInfoMngParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehiclePhonePageParam;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerInfoMngRespVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import com.elitesland.yst.production.aftersale.service.CarOwnerInfoService;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import com.elitesland.yst.production.aftersale.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pc/ownerInfoMng"}, produces={"application/json"})
@Validated
@Api(value="\u4e2d\u53f0\u7ba1\u7406\u7aef\u8f66\u4e3b\u4fe1\u606f\u7ba1\u7406", tags={"\u4e2d\u53f0\u7ba1\u7406\u7aef\u8f66\u4e3b\u4fe1\u606f\u7ba1\u7406"})
public class PcCarOwnerInfoMngController {
    private static final Logger log = LoggerFactory.getLogger(PcCarOwnerInfoMngController.class);
    @Autowired
    private CarOwnerInfoService carOwnerInfoService;
    @Autowired
    private CarOwnerVehicleService carOwnerVehicleService;
    private final ExportExcelService<CarOwnerInfoMngParam, CarOwnerInfoMngRespVO, Serializable> exportExcelService;

    @PostMapping(value={"/ownerInfoMngQuery"})
    @ApiOperation(value="\u8f66\u4e3b\u4fe1\u606f\u7ba1\u7406\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<CarOwnerInfoMngRespVO>> ownerInfoMngQuery(@RequestBody CarOwnerInfoMngParam param) {
        PagingVO<CarOwnerInfoMngRespVO> query = this.carOwnerInfoService.ownerInfoMngQuery(param);
        return ApiResult.ok(query);
    }

    @PostMapping(value={"/ownerInfoByUserPhone/page"})
    @ApiOperation(value="\u901a\u8fc7\u624b\u673a\u53f7\u5206\u9875\u67e5\u8be2\u8f66\u8f86\u4fe1\u606f")
    public ApiResult<PagingVO<CarOwnerVehicleInfoVO>> ownerInfoByUserPhonePage(@RequestBody CarOwnerVehiclePhonePageParam param) {
        PagingVO<CarOwnerVehicleInfoVO> carOwnerVehicleInfoVOPagingVO = this.carOwnerVehicleService.queryPageByPhone(param);
        return ApiResult.ok(carOwnerVehicleInfoVOPagingVO);
    }

    @GetMapping(value={"/ownerInfoMngDetail/{carOwnerId}"})
    @ApiOperation(value="\u8f66\u4e3b\u4fe1\u606f\u7ba1\u7406\u660e\u7ec6\u67e5\u8be2")
    public ApiResult<CarOwnerInfoMngRespVO> ownerInfoMngDetail(@PathVariable(value="carOwnerId") Long carOwnerId) {
        return ApiResult.ok((Object)this.carOwnerInfoService.ownerInfoMngDetail(carOwnerId));
    }

    @PostMapping(value={"/ownerInfoMngEnable"})
    @ApiOperation(value="\u8f66\u4e3b\u4fe1\u606f\u7ba1\u7406\u542f\u7528")
    public ApiResult ownerInfoMngEnable(@RequestBody List<Long> casUserIds) {
        this.carOwnerInfoService.ownerInfoMngUpdateStatus(casUserIds, true, 1);
        return ApiResult.ok();
    }

    @PostMapping(value={"/ownerInfoMngDisable"})
    @ApiOperation(value="\u8f66\u4e3b\u4fe1\u606f\u7ba1\u7406\u7981\u7528")
    public ApiResult ownerInfoMngDisable(@RequestBody List<Long> carOwnerIds) {
        this.carOwnerInfoService.ownerInfoMngUpdateStatus(carOwnerIds, false, 0);
        return ApiResult.ok();
    }

    @PostMapping(value={"/ownerInfoMngExport"}, produces={"application/octet-stream"})
    @ApiOperation(value="\u8f66\u4e3b\u4fe1\u606f\u7ba1\u7406\u5bfc\u51fa\u6570\u636e")
    public ApiResult<?> ownerInfoMngExport(HttpServletResponse response, @RequestBody CarOwnerInfoMngParam queryVO) {
        ExcelUtils.buildExportColumn(queryVO, CarOwnerInfoMngRespVO.class);
        try {
            this.exportExcelService.export((AbstractExportQueryParam)queryVO, response, this.carOwnerInfoService::ownerInfoMngQuery).get();
            return null;
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5931\u8d25\uff1a{}", (Throwable)e);
            return ApiResult.fail((String)("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/getUserFlmVehicleBindQty"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7ed1\u5b9a\u7684\u975e\u7acb\u9a6c\u8f66\u8f86\u7684\u6570\u91cf")
    public ApiResult<Integer> getUserFlmVehicleBindQty() {
        return ApiResult.ok((Object)this.carOwnerVehicleService.getUserFlmVehicleBindQty());
    }

    public PcCarOwnerInfoMngController(ExportExcelService<CarOwnerInfoMngParam, CarOwnerInfoMngRespVO, Serializable> exportExcelService) {
        this.exportExcelService = exportExcelService;
    }
}

