/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.dto.AfterSaleVehicleDTO;
import com.elitesland.yst.production.aftersale.dto.AfterSaleVehicleRespDTO;
import com.elitesland.yst.production.aftersale.dto.LmSaleLinkDTO;
import com.elitesland.yst.production.aftersale.model.entity.CarMaintainCardDO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerVehicleInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.TemTransmissionLogDO;
import com.elitesland.yst.production.aftersale.model.param.TemTransmissionLogParam;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import com.elitesland.yst.production.aftersale.out.sale.CrmSaleService;
import com.elitesland.yst.production.aftersale.out.support.OrgStoreService;
import com.elitesland.yst.production.aftersale.provider.sale.VinOrderRpcProvider;
import com.elitesland.yst.production.aftersale.provider.support.LmItmItemRpcProvider;
import com.elitesland.yst.production.aftersale.service.AfterSaleRpcService;
import com.elitesland.yst.production.aftersale.service.CarMaintainCardService;
import com.elitesland.yst.production.aftersale.service.TemTransmissionLogService;
import com.elitesland.yst.production.aftersale.service.impl.UserService;
import com.elitesland.yst.production.aftersale.service.repo.CarMaintainCardRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepoProc;
import com.elitesland.yst.production.aftersale.util.ConstantsAfterSale;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustCode2BaseParam;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustCode2BaseDTO;
import com.elitesland.yst.production.sale.rpc.param.VinOrderRpcDTO;
import com.elitesland.yst.production.support.provider.item.dto.LmItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ownerInfo"})
public class AfterSaleRpcServiceImpl
implements AfterSaleRpcService {
    private static final Logger log = LoggerFactory.getLogger(AfterSaleRpcServiceImpl.class);
    @Autowired
    private CarOwnerVehicleRepo carOwnerVehicleRepo;
    @Autowired
    private CarOwnerVehicleRepoProc carOwnerVehicleRepoProc;
    @Autowired
    private TemTransmissionLogService temporalLogService;
    @Autowired
    private OrgStoreService orgStoreService;
    @Autowired
    private CarMaintainCardService carMaintainCardService;
    @Autowired
    private CarMaintainCardRepo carMaintainCardRepo;
    @Autowired
    private LmItmItemRpcProvider lmItmItemRpcProvider;
    @Autowired
    private VinOrderRpcProvider vinOrderRpcProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmSaleService crmSaleService;
    private final String DOC_TYPE = "store";

    public ApiResult<List<AfterSaleVehicleRespDTO>> queryVehicle(AfterSaleVehicleDTO afterSaleVehicleDTO) {
        ArrayList dtoList = new ArrayList();
        ArrayList remarkList = new ArrayList();
        ArrayList<CarOwnerVehicleInfoDO> vehicleInfoDOList = new ArrayList<CarOwnerVehicleInfoDO>();
        log.info("\u5f00\u59cb\u7edf\u8ba1\u4e1a\u52a1\u5458\u7ed1\u5b9a\u8f66\u8f86\u6570\u636e:" + JSON.toJSONString((Object)afterSaleVehicleDTO));
        afterSaleVehicleDTO.setStartTime(afterSaleVehicleDTO.getStartTime() == null ? LocalDateTime.of(LocalDate.now().minusDays(1L), LocalTime.MIN) : afterSaleVehicleDTO.getStartTime());
        afterSaleVehicleDTO.setEndTime(afterSaleVehicleDTO.getEndTime() == null ? LocalDateTime.of(LocalDate.now().minusDays(1L), ConstantsAfterSale.LOCAL_TIME_MAX) : afterSaleVehicleDTO.getEndTime());
        List<CarMaintainCardDO> activeList = this.carMaintainCardRepo.findByCreateTimeBetween(afterSaleVehicleDTO.getStartTime(), afterSaleVehicleDTO.getEndTime());
        List<CarMaintainCardDO> cancelList = this.carMaintainCardRepo.findByModifyTimeBetween(afterSaleVehicleDTO.getStartTime(), afterSaleVehicleDTO.getEndTime());
        if (CollUtil.isNotEmpty(activeList)) {
            List<CarOwnerVehicleInfoDO> carOwnerVehicleInfoS = this.buildData(activeList);
            vehicleInfoDOList.addAll(carOwnerVehicleInfoS);
        }
        if (CollUtil.isNotEmpty(cancelList)) {
            List<CarOwnerVehicleInfoDO> carOwnerVehicleInfoDOS = this.buildData(cancelList);
            vehicleInfoDOList.addAll(carOwnerVehicleInfoDOS);
        }
        if (CollectionUtils.isEmpty(vehicleInfoDOList)) {
            return ApiResult.ok(dtoList);
        }
        log.info("\u7ed1\u8f66\u6570\u636e\u67e5\u8be2:{}" + vehicleInfoDOList);
        Map<Long, List<OrgStoreDetailRpcDTO>> stringListMap = this.storeQuery(vehicleInfoDOList);
        vehicleInfoDOList.stream().forEach(t -> {
            if (StringUtils.isNotEmpty((CharSequence)t.getVehicleType()) && t.getVehicleType().contains("/")) {
                t.setVehicleType(Arrays.stream(t.getVehicleType().split("/")).findFirst().get());
            }
        });
        log.info("\u95e8\u5e97\u67e5\u8be2\u6570\u636e:{}" + stringListMap);
        Map<String, List<CarOwnerVehicleInfoDO>> collect = vehicleInfoDOList.stream().filter(t -> t.getSalesOutletsId() != null).collect(Collectors.groupingBy(o -> o.getSalesOutletsRegionName() + "_" + o.getSalesOutletsCode() + "_" + o.getCustCode() + "_" + o.getSalesmanName() + "_" + o.getItemType3() + "_" + o.getVehicleType()));
        List activatList = activeList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List deleteList = cancelList.stream().map(BaseModel::getId).collect(Collectors.toList());
        collect.keySet().forEach(t -> {
            long countOne = 0L;
            long countTwo = 0L;
            AfterSaleVehicleRespDTO respDTO = new AfterSaleVehicleRespDTO();
            CarOwnerVehicleInfoDO statisticsVO = (CarOwnerVehicleInfoDO)((Object)((Object)((List)collect.get(t)).get(0)));
            if (!CollectionUtils.isEmpty((Collection)activatList)) {
                countOne = ((List)collect.get(t)).stream().filter(v -> activatList.contains(v.getId())).count();
            }
            if (!CollectionUtils.isEmpty((Collection)deleteList)) {
                countTwo = ((List)collect.get(t)).stream().filter(v -> deleteList.contains(v.getId())).count();
            }
            respDTO.setCustCode(statisticsVO.getCustCode());
            respDTO.setCustCode2(statisticsVO.getCustCode2());
            respDTO.setCustName(statisticsVO.getCustName());
            respDTO.setRegion(statisticsVO.getSalesOutletsRegion());
            respDTO.setSalesmanPath(statisticsVO.getSalesmanName());
            respDTO.setItemType3(statisticsVO.getItemType3());
            respDTO.setItemType5(statisticsVO.getVehicleType());
            respDTO.setShipQty(BigDecimal.valueOf(countOne - countTwo));
            respDTO.setDocTime(afterSaleVehicleDTO.getStartTime());
            if (MapUtil.isNotEmpty((Map)stringListMap) && statisticsVO.getSalesOutletsId() != null) {
                List orgStoreDetailRpcDTOS = (List)stringListMap.get(statisticsVO.getSalesOutletsId());
                if (!CollectionUtils.isEmpty((Collection)orgStoreDetailRpcDTOS)) {
                    OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = (OrgStoreDetailRpcDTO)orgStoreDetailRpcDTOS.get(0);
                    if (Objects.nonNull(orgStoreDetailRpcDTO)) {
                        respDTO.setStoreType2(orgStoreDetailRpcDTO.getStoreType2());
                        respDTO.setStoreCode(orgStoreDetailRpcDTO.getStoreCode());
                        respDTO.setStoreName(orgStoreDetailRpcDTO.getStoreName());
                        if (!Objects.isNull(orgStoreDetailRpcDTO.getAddressRpcDTO())) {
                            respDTO.setDetailAddr(Objects.isNull(orgStoreDetailRpcDTO.getAddressRpcDTO()) ? null : orgStoreDetailRpcDTO.getAddressRpcDTO().getDetailAddr());
                        }
                    }
                } else {
                    String remark = "\u65e0\u95e8\u5e97: " + statisticsVO.getSalesOutletsId();
                    remarkList.add(remark);
                }
            }
            dtoList.add(respDTO);
        });
        log.info("\u7ed3\u675f\u7edf\u8ba1\u4e1a\u52a1\u5458\u7ed1\u5b9a\u8f66\u8f86\u6570\u636e:{}" + dtoList);
        CompletableFuture<TemTransmissionLogDO> objectCompletableFuture = CompletableFuture.supplyAsync(() -> {
            TemTransmissionLogParam param = new TemTransmissionLogParam();
            param.setDealFlag(true);
            param.setFromStr(JSON.toJSONString((Object)afterSaleVehicleDTO));
            param.setRetNum(Long.valueOf(dtoList.size()));
            param.setSourcePlatform("sale");
            param.setRetStr(JSON.toJSONString((Object)dtoList));
            param.setRemark(CollectionUtils.isEmpty((Collection)remarkList) ? null : JSON.toJSONString((Object)remarkList));
            TemTransmissionLogDO res = this.temporalLogService.save(param);
            return res;
        });
        try {
            TemTransmissionLogDO temTransmissionLogDO = objectCompletableFuture.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return ApiResult.ok(dtoList);
    }

    private List<CarOwnerVehicleInfoDO> buildData(List<CarMaintainCardDO> list) {
        List<CarOwnerVehicleInfoVO> allByStoreCode = this.carOwnerVehicleRepoProc.findAllByStoreCode(list.stream().map(CarMaintainCardDO::getSalesOutletsCode).collect(Collectors.toList()));
        Map<String, String> salesmanMap = allByStoreCode.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getSalesOutletsCode())).filter(x -> StringUtils.isNotEmpty((CharSequence)x.getSalesmanName())).collect(Collectors.toMap(CarOwnerVehicleInfoVO::getSalesOutletsCode, CarOwnerVehicleInfoVO::getSalesmanName, (v1, v2) -> v1));
        Map<String, String> regionMap = this.userService.sysUdcGetCodeMap("yst-supp", "REGION");
        List<String> vinList = list.stream().map(CarMaintainCardDO::getVehicleNo).collect(Collectors.toList());
        List<VinOrderRpcDTO> vinOrderRpcDTOS = this.vinOrderRpcProvider.getByVinNos(vinList);
        CustCode2BaseParam code2BaseParam = new CustCode2BaseParam();
        code2BaseParam.setCustCode2(list.stream().map(CarMaintainCardDO::getCustCode2).collect(Collectors.toList()));
        List<CustCode2BaseDTO> custBaseInfo = this.crmSaleService.getCustByCustCode2(code2BaseParam);
        Map<Object, Object> itemMap = new HashMap();
        Map<Object, Object> vinNoMap = new HashMap();
        Map<Object, Object> custMap = new HashMap();
        if (CollUtil.isNotEmpty(vinOrderRpcDTOS)) {
            vinNoMap = vinOrderRpcDTOS.stream().collect(Collectors.toMap(VinOrderRpcDTO::getVinNo, t -> t, (v1, v2) -> v1));
            List itemCodes = vinOrderRpcDTOS.stream().map(VinOrderRpcDTO::getMtnrv).collect(Collectors.toList());
            ItmItemRpcParam param = new ItmItemRpcParam();
            param.setItemCodes(itemCodes);
            List<LmItmItemRpcDTO> itmItemRpcDTOS = this.lmItmItemRpcProvider.findSkuByParam(param);
            if (CollUtil.isNotEmpty(itmItemRpcDTOS)) {
                itemMap = itmItemRpcDTOS.stream().collect(Collectors.toMap(LmItmItemRpcDTO::getItemCode, t -> t, (v1, v2) -> v1));
            }
        }
        if (CollUtil.isNotEmpty(custBaseInfo)) {
            custMap = custBaseInfo.stream().collect(Collectors.toMap(CustCode2BaseDTO::getCustCode2, CustCode2BaseDTO::getCustCode, (v1, v2) -> v1));
        }
        HashMap finalItemMap = itemMap;
        HashMap finalVinNoMap = vinNoMap;
        HashMap finalCustMap = custMap;
        List<CarOwnerVehicleInfoDO> carOwnerVehicleInfoDOList = list.stream().map(x -> {
            CarOwnerVehicleInfoDO infoDO = new CarOwnerVehicleInfoDO();
            infoDO.setCustName(x.getCustName());
            infoDO.setId(x.getId());
            infoDO.setSalesOutletsRegion(x.getRegion());
            infoDO.setSalesOutletsRegionName((String)regionMap.get(x.getRegion()));
            infoDO.setCustCode2(x.getCustCode2());
            if (CollUtil.isNotEmpty((Map)finalCustMap) && finalCustMap.containsKey(x.getCustCode2())) {
                infoDO.setCustCode((String)finalCustMap.get(x.getCustCode2()));
            }
            infoDO.setSalesOutletsId(x.getSalesOutletsId());
            infoDO.setVehicleType(x.getVehicleType());
            infoDO.setSalesOutletsCode(x.getSalesOutletsCode());
            if (CollUtil.isNotEmpty((Map)finalVinNoMap) && finalVinNoMap.containsKey(x.getVehicleNo())) {
                VinOrderRpcDTO vinOrderRpcDTO = (VinOrderRpcDTO)finalVinNoMap.get(x.getVehicleNo());
                if (CollUtil.isNotEmpty((Map)finalItemMap) && finalItemMap.containsKey(vinOrderRpcDTO.getMtnrv())) {
                    LmItmItemRpcDTO lmItmItemRpcDTO = (LmItmItemRpcDTO)finalItemMap.get(vinOrderRpcDTO.getMtnrv());
                    infoDO.setItemType3(lmItmItemRpcDTO.getItemType3());
                } else {
                    infoDO.setItemType3("230");
                }
            }
            if (CollUtil.isNotEmpty((Map)salesmanMap) && salesmanMap.containsKey(x.getSalesOutletsCode())) {
                infoDO.setSalesmanName((String)salesmanMap.get(x.getSalesOutletsCode()));
            } else {
                infoDO.setSalesmanName("");
            }
            return infoDO;
        }).collect(Collectors.toList());
        return carOwnerVehicleInfoDOList;
    }

    public Map<Long, List<OrgStoreDetailRpcDTO>> storeQuery(List<CarOwnerVehicleInfoDO> vehicleInfoDOS) {
        List<Long> collect = vehicleInfoDOS.stream().filter(t -> t.getSalesOutletsId() != null).map(CarOwnerVehicleInfoDO::getSalesOutletsId).collect(Collectors.toList());
        Map<Long, List<OrgStoreDetailRpcDTO>> storeMap = this.orgStoreService.queryByIds(collect).stream().collect(Collectors.groupingBy(OrgStoreDetailRpcDTO::getId));
        return storeMap;
    }

    public ApiResult<List<LmSaleLinkDTO>> queryVehicleTypeByItemType5(String itemType5) {
        List<CarMaintainCardDO> collect = this.carMaintainCardService.queryVehicleTypeByItemType5(itemType5);
        List list = collect.stream().map(item -> {
            LmSaleLinkDTO lmSaleLinkDTO = new LmSaleLinkDTO();
            lmSaleLinkDTO.setVehicleNo(item.getVehicleNo());
            lmSaleLinkDTO.setVehicleType(item.getVehicleType());
            return lmSaleLinkDTO;
        }).collect(Collectors.toList());
        return ApiResult.ok(list);
    }
}

