package com.elitesland.yst.dataturbo.controller;

import com.elitesland.yst.dataturbo.controller.request.DataTurboTransferRequest;
import com.elitesland.yst.dataturbo.service.DataTurboService;
import com.elitesland.yst.dataturbo.service.param.DataTurboProcessParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value = "DataTurbo", tags = {"DataTurbo"})
@RestController
@RequestMapping("/dataTurbo")
public class DataTurboTransferController {

    @Autowired
    private DataTurboService dataTurboService;

    @PostMapping("/transfer")
    @ApiOperation("转换参数")
    public Object transfer(@RequestBody DataTurboTransferRequest request){
        DataTurboProcessParam param = new DataTurboProcessParam();
        BeanUtils.copyProperties(request, param);
        Object process = dataTurboService.transfer(param);
        return process;
    }

}
