/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.dataturbo.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitesland.yst.dataturbo.service.dto.DataTurboInvokeDTO;
import com.elitesland.yst.dataturbo.service.param.DataTurboInvokeParam;
import com.elitesland.yst.dataturbo.threadpool.CloseableHttpClientResourcePool;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTurboInvokeTask
implements Callable<DataTurboInvokeDTO> {
    private static final Logger log = LoggerFactory.getLogger(DataTurboInvokeTask.class);
    private final CloseableHttpClientResourcePool httpClientResourcePool;
    private final Map<String, String> header = new HashMap<String, String>();
    private final DataTurboInvokeParam dataTurboInvokeParam;
    private final String url;

    public DataTurboInvokeTask(CloseableHttpClientResourcePool httpClientResourcePool, DataTurboInvokeParam dataTurboInvokeParam, String url) {
        this.httpClientResourcePool = httpClientResourcePool;
        this.dataTurboInvokeParam = dataTurboInvokeParam;
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTurboInvokeDTO call() throws Exception {
        CloseableHttpClient httpClient = this.httpClientResourcePool.acquireResource(10000L);
        String currentUrl = String.format(this.url, this.dataTurboInvokeParam.getProcessName(), this.dataTurboInvokeParam.getProjectName(), this.dataTurboInvokeParam.getUserName());
        HttpPost httpPost = new HttpPost(currentUrl);
        for (Map.Entry<String, String> entry : this.header.entrySet()) {
            httpPost.setHeader(entry.getKey(), entry.getValue());
        }
        httpPost.setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        String jsonString = JSON.toJSONString(this.dataTurboInvokeParam.getStartParams());
        StringEntity entity = new StringEntity(jsonString, Charset.defaultCharset());
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            log.info("begin request dataTurbo process,request body:{}", (Object)this.dataTurboInvokeParam);
            response = httpClient.execute((HttpUriRequest)httpPost);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info(" ataTurbo process,response:{}", (Object)result);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            DataTurboInvokeDTO dataTurboInvokeDTO = (DataTurboInvokeDTO)JSONObject.toJavaObject((JSON)jsonObject, DataTurboInvokeDTO.class);
            return dataTurboInvokeDTO;
        }
        catch (Exception t) {
            log.error("sendHttp exception: ", (Throwable)t);
            DataTurboInvokeDTO dataTurboInvokeDTO = new DataTurboInvokeDTO();
            dataTurboInvokeDTO.setCode(-1);
            dataTurboInvokeDTO.setMsg(t.getMessage());
            dataTurboInvokeDTO.setSuccess(false);
            DataTurboInvokeDTO dataTurboInvokeDTO2 = dataTurboInvokeDTO;
            return dataTurboInvokeDTO2;
        }
        finally {
            if (httpClient != null) {
                this.httpClientResourcePool.releaseResource(httpClient);
            }
        }
    }
}

