package com.elitesland.yst.dataturbo.service.impl;

import com.elitesland.yst.dataturbo.service.DataTurboInvokeService;
import com.elitesland.yst.dataturbo.service.dto.DataTurboInvokeDTO;
import com.elitesland.yst.dataturbo.service.param.DataTurboInvokeParam;
import com.elitesland.yst.dataturbo.task.DataTurboInvokeTask;
import com.elitesland.yst.dataturbo.threadpool.CloseableHttpClientResourcePool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DataTurboInvokeServiceImpl implements DataTurboInvokeService {

    @Autowired
    private CloseableHttpClientResourcePool httpClientResourcePool;

    @Value("${elitesland.dataTurbo.url}")
    private String dataTurboUrl;

    @Value("${elitesland.dataTurbo.user}")
    private String dataTurboUser;

    @Value("${elitesland.dataTurbo.project}")
    private String dataTurboProject;
    @Override
    public DataTurboInvokeDTO invoke(DataTurboInvokeParam dataTurboInvokeParam) throws Exception {
        dataTurboInvokeParam.setUserName(dataTurboUser);
        dataTurboInvokeParam.setProjectName(dataTurboProject);
        DataTurboInvokeTask dataTurboInvokeTask =
                new DataTurboInvokeTask(httpClientResourcePool, dataTurboInvokeParam, dataTurboUrl);
        return dataTurboInvokeTask.call();
    }
}
