/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.dataturbo.threadpool;

import com.elitesland.yst.dataturbo.service.dto.DataTurboInvokeDTO;
import com.elitesland.yst.dataturbo.task.DataTurboInvokeTask;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DataTurboInvokeTheadPool
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DataTurboInvokeTheadPool.class);
    private ThreadPoolExecutor executor;
    private static final int CORE_POOL_SIZE = 50;
    private static final int MAX_CORE_SIZE = 100;
    private static final int KEEP_ALIVE_TIME = 10;

    public void afterPropertiesSet() {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        this.executor = new ThreadPoolExecutor(50, 100, 10L, TimeUnit.SECONDS, workQueue, new ThreadPoolExecutor.CallerRunsPolicy());
        log.info("^_^\u521d\u59cb\u5316DataTurbo\u8c03\u5ea6\u63a5\u53e3\u7ebf\u7a0b\u6c60\u6210\u529f[{}]", (Object)this.executor.hashCode());
    }

    public Future<DataTurboInvokeDTO> submit(DataTurboInvokeTask task) {
        return this.executor.submit(task);
    }
}

