package com.elitesland.yst.production.fin.dto.payorder;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhiyu.he
 * @date 2022/3/16 10:36
 */
@Data
public class PayOrderDtlRpcDTO implements Serializable {

    private static final long serialVersionUID = -9126525154153716180L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("总单ID")
    private Long masId;

    @ApiModelProperty("付款方式")
    private String payType;

    @ApiModelProperty("我方开户行名称")
    private String payBank;

    @ApiModelProperty("我方银行账号")
    private String payAccount;

    @ApiModelProperty("收款银行名称")
    private String recBank;

    @ApiModelProperty("收款银行账号")
    private String recAccount;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源行号")
    private Integer sourceLine;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("来源ID")
    private Long sourceId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("来源行号ID")
    private Long sourceLineId;

    @ApiModelProperty("实际支付金额")
    private BigDecimal realPayAmt;

    @ApiModelProperty("实际支付金额(本位币)")
    private BigDecimal realPayCurAmt;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("费用类型")
    private String expensesType;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("费用部门ID")
    private Long buId;

    @ApiModelProperty("费用部门")
    private String buName;

    @ApiModelProperty("费用部门编码")
    private String buCode;

    @ApiModelProperty("备注")
    private String remark;

}
