package com.elitesland.yst.production.fin.dto.pay;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2022/12/28 13:05
 */
@Data
public class PayRpcResultDTO implements Serializable {
    private static final long serialVersionUID = -6940079767993316959L;

    @ApiModelProperty("支付状态")
    private Boolean status;

    @ApiModelProperty("失败原因")
    private String errorMsg;

    @ApiModelProperty("支付方式")
    private String payMethod;

    @ApiModelProperty("支付金额")
    private BigDecimal payAmount;

    @ApiModelProperty("订单编号")
    private String orderNumber;

    @ApiModelProperty("收款类型")
    private String receiptType;

    @ApiModelProperty("收款流水")
    private String receiptSerial;

    @ApiModelProperty("支付日期")
    private LocalDateTime receiptDate;
}
