package com.elitesland.yst.production.fin.dto.saleinv;


import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 *已开发票明细
 */
@Data
public class SaleInvdDtlRpcDTO implements Serializable {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("关联id")
    private Long masId;

    @ApiModelProperty("发票号码")
    private String invNo;

    @ApiModelProperty("发票代码")
    private String invCode;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("校验码")
    private String checkCode;

    @ApiModelProperty("原蓝票代码")
    private String blueInvCode;

    @ApiModelProperty("原蓝票号码")
    private String blueInvNo;

    @ApiModelProperty("开票金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("开票日期")
    private LocalDateTime invDate;

    @ApiModelProperty("红冲状态")
//    @SysCode(sys = "FIN", mod = "RED_STATE")
    private String redState;

    @ApiModelProperty("开票状态")
//    @SysCode(sys = "FIN", mod = "INV_STATE")
    private String invState;

    @ApiModelProperty("pdf链接")
    private String invPdfUrl;

    @ApiModelProperty("开票失败原因")
    private String invFailCause;


}