package com.elitesland.yst.production.fin.dto.pay;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2023/1/6 14:44
 */
@Data
public class DrawBackResultDTO implements Serializable {
    private static final long serialVersionUID = 7042944704218704591L;

    @ApiModelProperty("退款状态")
    private Boolean status;

    @ApiModelProperty("失败原因")
    private String errorMsg;

    @ApiModelProperty("支付方式")
    private String payMethod;

    @ApiModelProperty("退款金额")
    private BigDecimal payAmount;

    @ApiModelProperty("订单编号")
    private String orderNumber;

    @ApiModelProperty("收款类型")
    private String receiptType;

    @ApiModelProperty("退款流水")
    private String receiptSerial;

    @ApiModelProperty("支付日期")
    private LocalDateTime receiptDate;

    @ApiModelProperty("收款公司id")
    private Long receiptOuId;

    @ApiModelProperty("收款公司编号")
    private String receiptOuCode;

    @ApiModelProperty("收款公司名称")
    private String receiptOuName;

    @ApiModelProperty("收款公司账户")
    private String receiptAccount;

    @ApiModelProperty("付款公司id")
    private Long payOuId;

    @ApiModelProperty("付款公司编号")
    private String payOuCode;

    @ApiModelProperty("付款公司名称")
    private String payOuName;

    @ApiModelProperty("付款公司账户")
    private String payAccount;
}
