package com.elitesland.yst.production.fin.param.aporder;

import com.elitesland.yst.production.fin.dto.aporder.ApOrderDtlGroupRpcDTO;
import com.elitesland.yst.production.fin.dto.aporder.ApOrderDtlRpcDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.yst.production.fin.param
 * @date 2022/5/17 15:39
 */
@Data
public class ApOrderRpcParam implements Serializable {


    private static final long serialVersionUID = 5056127372025402235L;

    @ApiModelProperty(value = "来源系统单号")
    private String sourceNo;

    @ApiModelProperty(value = "应付单编号")
    private String apOrderNo;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "来源单据")
    private String createMode;

    @ApiModelProperty(value = "应付单类型定义ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long apTypeId;

    @ApiModelProperty(value = "应付单类型名称")
    private String apTypeName;

    @ApiModelProperty(value = "应付单类型代码")
    private String apTypeCode;

    @ApiModelProperty(value = "单据状态")
    private String orderState;

    @ApiModelProperty(value = "业务日期")
    private LocalDateTime buDate;

    @ApiModelProperty(value = "含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmt;

    @ApiModelProperty(value = "税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty(value = "含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty(value = "不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty(value = "不含税总金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty(value = "币种编码")
    private String currCode;

    @ApiModelProperty(value = "币种")
    private String currName;

    @ApiModelProperty(value = "审核人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long auditUserId;

    @ApiModelProperty(value = "审核人")
    private String auditUser;

    @ApiModelProperty(value = "审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty(value = "经办人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long operUserId;

    @ApiModelProperty(value = "经办人")
    private String operator;

    @ApiModelProperty(value = "是否期初")
    private Boolean initFlag;

    @ApiModelProperty(value = "供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty(value = "供应商编码")
    private String suppCode;

    @ApiModelProperty(value = "供应商名称")
    private String suppName;

    @ApiModelProperty(value = "创建人")
    private String creator;

    @ApiModelProperty(value = "审核拒绝意见")
    private String auditRejection;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "是否含税")
    private Boolean taxFlag;

    @ApiModelProperty(value = "汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty(value = "部门ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty(value = "部门编码")
    private String buCode;

    @ApiModelProperty(value = "部门名称")
    private String buName;

    @ApiModelProperty(value = "付款条件")
    private String payMentName;
    private String payMentId;
    private String payMentCode;

    @ApiModelProperty(value = "创建日期")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改人")
    private String updater;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;


    @ApiModelProperty(value = "总数量，汇总明细单行数")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long totalCount;

    @ApiModelProperty(value = "传输状态")
    private String tranState;

    @ApiModelProperty(value = "入账日期")
    private String entryDate;

    @ApiModelProperty("应付单明细信息")
    private List<ApOrderDtlRpcDTO> apOrderDtlRpcDTOList;

    @ApiModelProperty("应付单汇总信息")
    private List<ApOrderDtlGroupRpcDTO> apOrderDtlGroupRpcDTOList;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("核销状态")
    private String verState;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

}
