package com.elitesland.yst.production.fin.application.facade.vo.paytype;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhiyu.he
 * @date 2022/3/16 10:41
 */
@Data
public class PayTypeOuVO implements Serializable {

    private static final long serialVersionUID = -1880611145954218770L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("付款单类型定义ID")
    private Long payTypeId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司类型[UDC]ORG:OU_TYPE")
    @SysCode(sys = "yst-supp", mod = "OU_TYPE")
    private String ouType;
    private String ouTypeName;

}
