package com.elitesland.yst.production.fin.application.service.aptype;

import com.elitesland.yst.production.fin.application.convert.aptype.ApTypeOuConvert;
import com.elitesland.yst.production.fin.application.facade.param.aptype.ApTypeOuParam;
import com.elitesland.yst.production.fin.application.facade.param.aptype.ApTypeOuSaveParam;
import com.elitesland.yst.production.fin.application.facade.vo.aptype.ApTypeOuVO;
import com.elitesland.yst.production.fin.domain.entity.aptype.ApTypeOu;
import com.elitesland.yst.production.fin.domain.param.aptype.ApTypeOuPageParam;
import com.elitesland.yst.production.fin.domain.service.aptype.ApTypeOuDomainService;
import com.elitesland.yst.production.fin.infr.dto.aptype.ApTypeOuDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.service.aptypeou
 * @date 2022/3/15 09:24
 */
@Service
@RequiredArgsConstructor
public class ApTypeOuServiceImpl implements ApTypeOuService {

    private final ApTypeOuDomainService apTypeOuDomainService;

    @SysCodeProc
    @Override
    public PagingVO<ApTypeOuVO> page(ApTypeOuPageParam apTypeOuParam) {

        PagingVO<ApTypeOuDTO> page = apTypeOuDomainService.page(apTypeOuParam);
        // DTO 转 VO
        PagingVO<ApTypeOuVO> res = ApTypeOuConvert.INSTANCE.convertPage(page);
        return res;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Boolean> addOu(ApTypeOuSaveParam apTypeOuSaveParam) {
        for (ApTypeOuParam apTypeOuParam : apTypeOuSaveParam.getApTypeOuParamList()) {
            ApTypeOu apTypeOu = ApTypeOuConvert.INSTANCE.convert(apTypeOuParam);
            apTypeOu.setApTypeId(apTypeOuSaveParam.getApTypeId());
            apTypeOuDomainService.addOu(apTypeOu);
        }
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Boolean> cancelOu(List<Long> ids) {
        apTypeOuDomainService.cancelOu(ids);
        return ApiResult.ok();
    }

}
