package com.elitesland.yst.production.fin.application.service.apverrec;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ReflectUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitesland.yst.production.fin.application.convert.apverrec.ApVerRecDtlConvert;
import com.elitesland.yst.production.fin.application.facade.param.apverrec.ApVerRecParam;
import com.elitesland.yst.production.fin.application.facade.vo.apverrec.ApVerRecDtlVO;
import com.elitesland.yst.production.fin.common.FinConstant;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.domain.entity.apverrec.ApVerRecDtl;
import com.elitesland.yst.production.fin.domain.param.apverrec.ApVerRecPageParam;
import com.elitesland.yst.production.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.yst.production.fin.domain.service.apverconfig.ApVerConfigDomainService;
import com.elitesland.yst.production.fin.domain.service.apverrec.ApVerRecDomainService;
import com.elitesland.yst.production.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.yst.production.fin.infr.dto.apverconfig.ApVerConfigDTO;
import com.elitesland.yst.production.fin.infr.dto.apverconfig.ApVerConfigDtlDTO;
import com.elitesland.yst.production.fin.infr.dto.apverrec.ApVerRecDtlDTO;
import com.elitesland.yst.production.fin.infr.factory.apverrec.ApVerRecFactory;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author Jason.zhao
 * @date 2022/4/22 17:51
 */
@Service
@RequiredArgsConstructor
public class ApVerRecServiceImpl implements ApVerRecService{

    private final ApVerRecDomainService apVerRecDomainService;

    private final ApVerConfigDomainService apVerConfigDomainService;

    private final ApOrderDomainService apOrderDomainService;

    private final PayOrderDomainService payOrderDomainService;

    private final ApVerRecFactory apVerRecFactory;

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void confirm(ApVerRecParam param) {
        ApVerConfigDTO apVerConfigDTO = apVerConfigDomainService.queryById(param.getConfigId());
        if(apVerConfigDTO==null || !apVerConfigDTO.getEnableFlag()){
            throw new BusinessException("该方案[应付核销方案ID"+param.getConfigId()+"]不存在或已停用");
        }
        List<ApVerConfigDtlDTO> configDtlDTOList = apVerConfigDTO.getApVerConfigDtlDTOList().stream().filter(ApVerConfigDtlDTO::getMatchFlag).collect(Collectors.toList());

        Map<String, ?> conditions = configDtlDTOList.stream().collect(Collectors.toMap(ApVerConfigDtlDTO::getFieldNo,t->{
                    if(t.getFieldType().equals(FinConstant.STRING)){
                        return String.class;
                    } else if(t.getFieldType().equals(FinConstant.BIGDECIMAL)){
                        return BigDecimal.class;
                    } else if(t.getFieldType().equals(FinConstant.LOCALDATETIME)){
                            return LocalDateTime.class;
                    } else if(t.getFieldType().equals(FinConstant.LONG)){
                        return Long.class;
                    }
                    return String.class;
                }));
        //设置核销方案数据
        param.getParams().forEach(s->{
            s.setSchemeId(apVerConfigDTO.getId());
            s.setSchemeName(apVerConfigDTO.getSchemeName());
            s.setSchemeNo(apVerConfigDTO.getSchemeNo());
            s.setVerifyType(UdcEnum.FIN_VERIFY_TYPE_MANU.getValueCode());
        });
        List<ApVerRecDtl> apVerRecDtls = ApVerRecDtlConvert.INSTANCE.convertList(param.getParams());

        Map<String, List<ApVerRecDtl>> listMap = apVerRecDtls.stream().collect(Collectors.groupingBy(t -> groupByCond(t, conditions)));
        for (Map.Entry<String, List<ApVerRecDtl>> entry : listMap.entrySet()){
            apVerRecDomainService.save(entry.getValue());
        }
        apVerRecDtls.stream().forEach(t->{
            if(t.getOrderType().equals(FinConstant.AP)){
                apOrderDomainService.updateVerAmt(t.getOrderId(),t.getAmt());
            }else if (t.getOrderType().equals(FinConstant.PAY)){
                payOrderDomainService.updateVerAmt(t.getOrderId(),t.getAmt());
            }
        });
    }

    @Override
    @SysCodeProc
    public PagingVO<ApVerRecDtlVO> page(ApVerRecPageParam pageParam) {
        PagingVO<ApVerRecDtlDTO> page = apVerRecFactory.page(pageParam);
        return ApVerRecDtlConvert.INSTANCE.convertPage(page);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void cancel(List<Long> ids) {
        if(CollUtil.isEmpty(ids)){
            throw new BusinessException("传入参数不能为空");
        }
        Set<Long> masIds = ids.stream().collect(Collectors.toSet());
        List<ApVerRecDtlDTO> recDtlDTOS = apVerRecDomainService.queryDtlByMasIds(masIds);
        if(CollUtil.isEmpty(recDtlDTOS)){
            throw new BusinessException("应付核销明细查询为空");
        }
        List<Long> dtlIds = recDtlDTOS.stream().map(ApVerRecDtlDTO::getId).collect(Collectors.toList());
        SysUserDTO user = SecurityContextUtil.currentUser().getUser();
        Long rows = apVerRecDomainService.logicDelByIds(masIds,user.getUsername(),user.getId());
        Long dtlRows = apVerRecDomainService.logicDelDtlByIds(dtlIds);
        if(rows.intValue()!=masIds.size() || dtlRows.intValue()!= dtlIds.size()){
            throw new BusinessException("取消应付核销失败");
        }
        Map<Long, List<ApVerRecDtlDTO>> recDtlDTOMap = recDtlDTOS.stream().collect(Collectors.groupingBy(ApVerRecDtlDTO::getOrderId));
        for (Map.Entry<Long, List<ApVerRecDtlDTO>> entry : recDtlDTOMap.entrySet()){
            String orderType = entry.getValue().get(0).getOrderType();
            BigDecimal amt = entry.getValue().stream().map(ApVerRecDtlDTO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
            if(orderType.equals(FinConstant.AP)){
                apOrderDomainService.updateVerAmt(entry.getKey(),amt);
            }else if (orderType.equals(FinConstant.PAY)){
                payOrderDomainService.updateVerAmt(entry.getKey(),amt);
            }
        }
    }

    private String groupByCond(Object object, Map<String,?> conditions) {
        StringBuilder key=new StringBuilder();
        for (Map.Entry<String,?> cond : conditions.entrySet()){
            Object fieldValue = ReflectUtil.getFieldValue(object, cond.getKey());
            if (cond.getValue().equals(LocalDateTime.class)){
                key.append(((LocalDateTime) fieldValue).toLocalDate().toString()).append("&");
            }else {
                key.append(fieldValue.toString()).append("&");
            }
        }
        return key.toString();
    }

}
