package com.elitesland.yst.production.fin.domain.entity.inputinv;

import cn.hutool.core.lang.Assert;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2022/5/6 9:07
 */
@Data
public class InputInvDtl {

    private Long id;

    private Long masId;

    private String invNo;

    private String invCode;

    private String blueInvNo;

    private LocalDateTime invDate;

    private String sourceNo;

    private Long sourceLineId;

    private Long sourceId;

    private Integer sourceLine;

    private Long itemId;

    private String itemName;

    private String itemCode;

    private String itemType;

    private String uom;

    private String uomName;

    private BigDecimal qty;

    private BigDecimal price;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal taxRate;

    private BigDecimal taxAmt;

    private BigDecimal taxCurAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal exclTaxCurAmt;

    private String invType;

    private String invKind;

    private String invState;

    private String examType;

    private String remark;


    //必填项非空校验
    public void checkNotNull(String createMode) {
        // 采购收货单
        if (createMode.equals(UdcEnum.FIN_PINV_CREATE_MODE_GR.getValueCode())) {
            Assert.notNull(this.sourceLine, "来源行号不能为空");
            Assert.notNull(this.sourceNo, "来源单号不能为空");
            Assert.notNull(this.itemType, "规格型号不能为空");
            Assert.notNull(this.uom, "单位不能为空");
            Assert.notNull(this.exclTaxAmt, "不含税金额不能为空");
            Assert.notNull(this.exclTaxCurAmt, "不含税金额本位币不能为空");
            Assert.notNull(this.examType, "查验状态不能为空");

        }
        Assert.notNull(this.totalAmt, "含税金额不能为空");
        Assert.notNull(this.totalCurAmt, "含税金额本位币不能为空");
        Assert.notNull(this.invNo, "发票号码不能为空");
        Assert.notNull(this.invDate, "开票日期不能为空");
        Assert.notNull(this.itemCode, "商品编码不能为空");
        Assert.notNull(this.itemName, "商品名称不能为空");
        Assert.notNull(this.itemId, "商品ID不能为空");
        Assert.notNull(this.qty, "数量不能为空");
        Assert.notNull(this.price, "含税单价不能为空");
        Assert.notNull(this.itemId, "商品ID不能为空");
        Assert.notNull(this.taxRate, "税率不能为空");
        Assert.notNull(this.taxAmt, "税额不能为空");
        Assert.notNull(this.invType, "发票类型不能为空");
        Assert.notNull(this.invKind, "红（蓝）票不能为空");
        Assert.notNull(this.invState, "开票状态不能为空");
        if (new BigDecimal("0").compareTo(this.qty) == 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "数量不能为0 !");
        }
        // 含税单价
        Assert.notNull(this.price, "price is null");
        if (this.price.compareTo(BigDecimal.ZERO) < 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "含税单价需大于等于0 !");
        }
    }
}
