package com.elitesland.yst.production.fin.domain.entity.paytype;


import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;
/**
 * @author zhiyu.he
 * @date 2022/3/16 10:41
 */
@Entity
@Table(name="pay_type")
@org.hibernate.annotations.Table(appliesTo = "pay_type", comment = "付款单类型定义")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class PayTypeDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -1487220098827758004L;
    @Column(name = "pay_type_code", columnDefinition = "varchar(40) comment '付款单类型代码'")
    private String payTypeCode;

    @Column(name = "pay_type_name", columnDefinition = "varchar(40) comment '付款单类型名称'")
    private String payTypeName;

    @Column(name = "enable_flag", columnDefinition = "tinyint(1) comment '启用标志'")
    private Boolean enableFlag;

    @Column(name = "default_flag", columnDefinition = "tinyint(1) comment '默认'")
    private Boolean defaultFlag;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PayTypeDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PayTypeDO entity = (PayTypeDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
