package com.elitesland.yst.production.fin.entity.account;

import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

import com.elitescloud.boot.model.entity.BaseModel;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import org.hibernate.annotations.Where;
import lombok.EqualsAndHashCode;

/**
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 * @desc : 账户表
 */
@Entity
@Table(name = "account", indexes = {@Index(name = "idx_acc_name_code", columnList = "acc_name_code,tenantId", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "account", comment = "账户表")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class AccountDO extends BaseModel {

    @Column(name = "ou_code", columnDefinition = "varchar(255) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司id'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(255) comment '公司名称'")
    private String ouName;

    @Column(name = "ou_type", columnDefinition = "varchar(255) comment '公司类型'")
    private String ouType;

    @Column(name = "area", columnDefinition = "varchar(255) comment '所属区域'")
    private String area;

    @Column(name = "acc_code", columnDefinition = "varchar(255) comment '账户编码'")
    private String accCode;

    @Column(name = "acc_name", columnDefinition = "varchar(255) comment '账户名称'")
    private String accName;

    @Column(name = "acc_name_code", columnDefinition = "varchar(255) comment '账户名称编码'")
    private String accNameCode;

    @Column(name = "acc_type", columnDefinition = "varchar(255) comment '账户类型'")
    private String accType;

    @Column(name = "acc_amt", columnDefinition = "decimal(18,2) comment '账户金额'")
    private BigDecimal accAmt;

    @Column(name = "acc_occ_amt", columnDefinition = "decimal(18,2) comment '账户占用金额'")
    private BigDecimal accOccAmt;

    @Column(name = "state", columnDefinition = "varchar(255) comment '状态'")
    private String state;

    @Column(name = "area_name", columnDefinition = "varchar(255) comment '区域名称'")
    private String areaName;

    @Column(name = "area_id", columnDefinition = "bigint(20) comment '区域id'")
    private Long areaId;

}