package com.elitesland.yst.production.fin.entity.adjusttoorder;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hibernate.annotations.Where;

import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * @author  zhiyu.he
 * @date  2023/3/3 15:01
 */


@Entity
@org.hibernate.annotations.Table(appliesTo = "adjust_order_to", comment = "调剂单")
@Table(name="adjust_order_to", indexes =@Index(name = "idx_doc_no",columnList = "doc_no,tenantId",unique = true))
@Data
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0")
public class AdjustToOrderDO extends BaseModel {

    @Column(name = "doc_no", columnDefinition = "varchar(20) comment '调剂单号'")
    private String docNo;

    @Column(name = "state", columnDefinition = "varchar(20) comment '单据状态'")
    private String state;

    @Column(name = "type", columnDefinition = "varchar(20) comment '单据类型UDC'")
    private String type;

    @Column(name = "rec_acc_time", columnDefinition = "datetime(6) comment '记账日期'")
    private LocalDateTime recAccTime;

    @Column(name = "acc_name_from", columnDefinition = "varchar(50) comment '从账户名称'")
    private String accNameFrom;

    @Column(name = "acc_type_from", columnDefinition = "varchar(20) comment '从账户类型'")
    private String accTypeFrom;

    @Column(name = "acc_code_from", columnDefinition = "varchar(50) comment '从账户编码'")
    private String accCodeFrom;

    @Column(name = "adj_reason", columnDefinition = "varchar(20) comment '调整原因'")
    private String adjReason;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '总金额'")
    private BigDecimal totalAmt;

    @Column(name = "audit_user", columnDefinition = "varchar(20) comment '审核人'")
    private String auditUser;

    @Column(name = "audit_user_id", columnDefinition = "bigint(20) comment '审核人ID'")
    private Long auditUserId;

    @Column(name = "audit_time", columnDefinition = "datetime(6) comment '审核时间'")
    private LocalDateTime auditTime;

    @Column(name = "audit_reject_reason", columnDefinition = "varchar(255) comment '审核拒绝理由'")
    private String auditRejectReason;

    @Column(name = "ou_code", columnDefinition = "varchar(40) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(200) comment '公司名称'")
    private String ouName;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "acc_name_to", columnDefinition = "varchar(50) comment '至账户名称'")
    private String accNameTo;

    @Column(name = "acc_type_to", columnDefinition = "varchar(20) comment '至账户类型'")
    private String accTypeTo;

    @Column(name = "acc_code_to", columnDefinition = "varchar(50) comment '至账户编码'")
    private String accCodeTo;
}
