package com.elitesland.yst.production.fin.infr.dto.inputinv;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2022/5/6 17:04
 */
@Data
public class InputInvDtlDTO implements Serializable {

    private static final long serialVersionUID = -6070620812277543263L;
    private Long id;

    private Long masId;

    private String invNo;

    private String invCode;

    private String blueInvNo;

    private LocalDateTime invDate;

    private String sourceNo;

    private Long sourceLineId;

    private Long sourceId;

    private Integer sourceLine;

    private Long itemId;

    private String itemName;

    private String itemCode;

    private String itemType;

    private String uom;

    private String uomName;

    private BigDecimal qty;

    private BigDecimal price;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal taxRate;

    private BigDecimal taxAmt;

    private BigDecimal taxCurAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("发票类型")
    @SysCode(sys = "yst-fin", mod = "INV_TYPE")
    private String invType;
    private String invTypeName;

    @ApiModelProperty("红/蓝票")
    @SysCode(sys = "yst-fin",mod = "OPEN_TYPE")
    private String invKind;
    private String invKindName;

    @ApiModelProperty("开票状态")
    @SysCode(sys = "yst-fin",mod = "INV_STATE")
    private String invState;
    private String invStateName;

    @ApiModelProperty("查验状态")
    @SysCode(sys = "yst-fin",mod = "EXAM_TYPE")
    private String examType;
    private String examTypeName;

    private String remark;
}
