package com.elitesland.yst.production.fin.infr.factory.inputinv;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.excel.util.StringUtils;
import com.elitesland.yst.production.fin.domain.param.inputinv.InputInvPageParam;
import com.elitesland.yst.production.fin.infr.dto.inputinv.InputInvDTO;
import com.elitesland.yst.production.fin.infr.repo.inputinv.InputInvDtlRepoProc;
import com.elitesland.yst.production.fin.infr.repo.inputinv.InputInvRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/5/6 11:41
 */
@RequiredArgsConstructor
@Component
public class InputInvFactory {

    private final InputInvRepoProc inputInvRepoProc;

    private final InputInvDtlRepoProc inputInvDtlRepoProc;

    public PagingVO<InputInvDTO> payOrderPage(InputInvPageParam param) {
        if (!StringUtils.isEmpty(param.getInvNo()) || !StringUtils.isEmpty(param.getInvCode()) || !StringUtils.isEmpty(param.getInvType())) {
            List<Long> ids = inputInvDtlRepoProc.queryByParam(param).stream().distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(ids)) {
                return new PagingVO<>(0, new ArrayList<>());
            } else {
                return inputInvRepoProc.page(param, ids);
            }
        } else {
            return inputInvRepoProc.page(param, null);
        }
    }

}
