package com.elitesland.yst.production.fin.infr.factory.paytype;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.yst.production.fin.domain.param.paytype.PayTypePageParam;
import com.elitesland.yst.production.fin.infr.dto.paytype.PayTypeDTO;
import com.elitesland.yst.production.fin.infr.repo.paytype.PayTypeOuRepoProc;
import com.elitesland.yst.production.fin.infr.repo.paytype.PayTypeRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/3/16 17:10
 */
@RequiredArgsConstructor
@Component
public class PayTypeFactory {

    private final PayTypeRepoProc payTypeRepoProc;

    private final  PayTypeOuRepoProc payTypeOuRepoProc;

    public PagingVO<PayTypeDTO> payTypePage(PayTypePageParam param) {
        //如果公司ID为空走普通查询
        if (param.getOuId() != null) {
            //查询出所有付款单ID
            List<Long> ids = payTypeOuRepoProc.queryByOuId(param.getOuId()).stream().distinct().collect(Collectors.toList());
            //如果为空直接返回空
            if (CollUtil.isEmpty(ids)) {
                return new PagingVO<>(0,new ArrayList<>());
            } else {
                //不为空加上主键ID作为查询条件
                return payTypeRepoProc.page(param, ids);
            }
        } else {
            //为空走普通查询
            return payTypeRepoProc.page(param, null);
        }
    }

}
