package com.elitesland.yst.production.fin.infr.repo.aptype;


import com.elitesland.yst.production.fin.domain.entity.aptype.ApTypeOuDO;
import com.elitesland.yst.production.fin.domain.entity.aptype.QApTypeOuDO;
import com.elitesland.yst.production.fin.domain.param.aptype.ApTypeOuPageParam;
import com.elitesland.yst.production.fin.infr.dto.aptype.ApTypeOuDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.infr.repo.aptypeou
 * @date 2022/3/14 16:39
 */

@Component
@RequiredArgsConstructor
public class ApTypeOuRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QApTypeOuDO qApTypeOuDO = QApTypeOuDO.apTypeOuDO;


    public List<ApTypeOuDTO> queryByApTypeId(Long apTypeId) {
        return select(ApTypeOuDTO.class)
                .where(qApTypeOuDO.apTypeId.eq(apTypeId))
                .where(qApTypeOuDO.deleteFlag.eq(0))
                .fetch();
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qApTypeOuDO.id,
                qApTypeOuDO.apTypeId,
                qApTypeOuDO.ouCode,
                qApTypeOuDO.ouId,
                qApTypeOuDO.ouType,
                qApTypeOuDO.ouName)
        ).from(qApTypeOuDO);
    }


    public PagingVO<ApTypeOuDTO> page(ApTypeOuPageParam apTypeOuParam) {

        // 搜索条件拼接
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(apTypeOuParam.getKeyWord())) {
            predicates.add(qApTypeOuDO.ouCode.like(apTypeOuParam.getKeyWord()).or(qApTypeOuDO.ouName.like(apTypeOuParam.getKeyWord())));
        }
        if (null != apTypeOuParam.getApTypeId()) {
            predicates.add(qApTypeOuDO.apTypeId.eq(apTypeOuParam.getApTypeId()));
        }
        predicates.add(qApTypeOuDO.deleteFlag.eq(0));
        JPAQuery<ApTypeOuDTO> query = select(ApTypeOuDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        apTypeOuParam.setPaging(query);
        apTypeOuParam.fillOrders(query, qApTypeOuDO);
        return PagingVO.<ApTypeOuDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public Long cancelOu(List<Long> ids) {
        long execute = jpaQueryFactory.update(qApTypeOuDO)
                .set(qApTypeOuDO.deleteFlag, 1)
                .where(qApTypeOuDO.id.in(ids))
                .execute();
        return execute;
    }

    public List<Long> queryByOuId(Long ouId) {
        List<Long> res = jpaQueryFactory.select(qApTypeOuDO.apTypeId)
                .from(qApTypeOuDO)
                .where(qApTypeOuDO.ouId.eq(ouId))
                .where(qApTypeOuDO.deleteFlag.eq(0))
                .fetch();
        return res;
    }

    public Boolean existByApTypeIdOuId(ApTypeOuDO apTypeOuDO) {
        long res = jpaQueryFactory.select(qApTypeOuDO.id)
                .from(qApTypeOuDO)
                .where(qApTypeOuDO.deleteFlag.eq(0))
                .where(qApTypeOuDO.apTypeId.eq(apTypeOuDO.getApTypeId()))
                .where(qApTypeOuDO.ouId.eq(apTypeOuDO.getOuId()))
                .fetchCount();
        return res > 0;

    }
}
