package com.elitesland.yst.production.fin.infr.repo.arverconfig;

import com.elitesland.yst.production.fin.domain.entity.apverconfig.QApVerConfigDtlDO;
import com.elitesland.yst.production.fin.domain.entity.arverconfig.QArVerConfigDtlDO;
import com.elitesland.yst.production.fin.infr.dto.apverconfig.ApVerConfigDtlDTO;
import com.elitesland.yst.production.fin.infr.dto.arverconfig.ArVerConfigDtlDTO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/25 14:44
 */
@Component
@RequiredArgsConstructor
public class ArVerConfigDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QArVerConfigDtlDO qArVerConfigDtlDO = QArVerConfigDtlDO.arVerConfigDtlDO;


    public List<ArVerConfigDtlDTO> queryByMasId(Long masId) {
        return select(ArVerConfigDtlDTO.class)
                .where(qArVerConfigDtlDO.masId.eq(masId))
                .fetch();
    }

    public List<ArVerConfigDtlDTO> queryNoMasId() {
        return select(ArVerConfigDtlDTO.class)
                .where(qArVerConfigDtlDO.masId.isNull())
                .where(qArVerConfigDtlDO.deleteFlag.eq(0))
                .fetch();
    }

    public void deleteByMasId(Long masId) {
        jpaQueryFactory.delete(qArVerConfigDtlDO)
                .where(qArVerConfigDtlDO.masId.eq(masId))
                .execute();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qArVerConfigDtlDO.id,
                qArVerConfigDtlDO.masId,
                qArVerConfigDtlDO.fieldNo,
                qArVerConfigDtlDO.fieldName,
                qArVerConfigDtlDO.fieldType,
                qArVerConfigDtlDO.editFlag,
                qArVerConfigDtlDO.matchFlag,
                qArVerConfigDtlDO.remark,
                qArVerConfigDtlDO.createTime,
                qArVerConfigDtlDO.creator,
                qArVerConfigDtlDO.modifyTime,
                qArVerConfigDtlDO.modifyUserId,
                qArVerConfigDtlDO.updater)
        ).from(qArVerConfigDtlDO);
    }
}
