package com.elitesland.yst.production.fin.infr.repo.arverrec;

import com.elitesland.yst.production.fin.domain.entity.arverrec.QArVerRecDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Collection;

/**
 * @author zhiyu.he
 * @date 2022/4/26 13:21
 */
@Component
@RequiredArgsConstructor
public class ArVerRecRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QArVerRecDO qArVerRecDO = QArVerRecDO.arVerRecDO;

    public Long logicDelByIds(Collection<Long> ids,String userName,Long userId) {
        return jpaQueryFactory.update(qArVerRecDO).set(qArVerRecDO.deleteFlag, 1)
                .set(qArVerRecDO.cancelDate, LocalDateTime.now())
                .set(qArVerRecDO.cancelUser,userName)
                .set(qArVerRecDO.cancelUserId,userId)
                .where(qArVerRecDO.id.in(ids).and(qArVerRecDO.deleteFlag.eq(0))).execute();
    }

}
