package com.elitesland.yst.production.fin.infr.repo.inputinv;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.yst.production.fin.domain.entity.inputinv.QInputInvDtlDO;
import com.elitesland.yst.production.fin.domain.param.inputinv.InputInvDtlPageParam;
import com.elitesland.yst.production.fin.domain.param.inputinv.InputInvPageParam;
import com.elitesland.yst.production.fin.infr.dto.inputinv.InputInvDtlDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/5/6 10:24
 */
@Component
@RequiredArgsConstructor
public class InputInvDtlRepoProc {


    private final JPAQueryFactory jpaQueryFactory;

    private final QInputInvDtlDO qInputInvDtlDO = QInputInvDtlDO.inputInvDtlDO;

    public List<Long> queryByParam(InputInvPageParam param) {

        List<Predicate> predicates = new ArrayList<>();

        if (!StringUtils.isEmpty(param.getInvNo())) {
            predicates.add(qInputInvDtlDO.invNo.eq(param.getInvNo()));
        }
        if (!StringUtils.isEmpty(param.getInvCode())) {
            predicates.add(qInputInvDtlDO.invCode.like("%" + param.getInvCode() + "%"));
        }
        if (!StringUtils.isEmpty(param.getInvType())) {
            predicates.add(qInputInvDtlDO.invType.eq(param.getInvType()));
        }
        return jpaQueryFactory.select(qInputInvDtlDO.masId)
                .from(qInputInvDtlDO)
                .where(ExpressionUtils.allOf(predicates))
                .fetch();
    }

    public PagingVO<InputInvDtlDTO> page(InputInvDtlPageParam param) {
        List<Predicate> predicates = new ArrayList<>();
        if (param.getMasId() != null) {
            predicates.add(qInputInvDtlDO.masId.eq(param.getMasId()));
        }
        JPAQuery<InputInvDtlDTO> query = select(InputInvDtlDTO.class).where(ExpressionUtils.allOf(predicates));
        param.setPaging(query);
        param.fillOrders(query, qInputInvDtlDO);
        return PagingVO.<InputInvDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public Boolean checkUpdate(List<String> invNo, Long masId) {
        return jpaQueryFactory.select(qInputInvDtlDO.id)
                .from(qInputInvDtlDO)
                .where(qInputInvDtlDO.invNo.in(invNo))
                .where(qInputInvDtlDO.masId.notIn(masId))
                .fetchCount() > 0;
    }

    public Boolean checkAdd(List<String> invNo) {
        return jpaQueryFactory.select(qInputInvDtlDO.id)
                .from(qInputInvDtlDO)
                .where(qInputInvDtlDO.invNo.in(invNo))
                .fetchCount() > 0;
    }

    public void deleteByMasId(List<Long> ids) {
        jpaQueryFactory.delete(qInputInvDtlDO)
                .where(qInputInvDtlDO.masId.in(ids))
                .execute();
    }

    @SysCodeProc
    public List<InputInvDtlDTO> queryByMasId(Long masId) {
        return select(InputInvDtlDTO.class)
                .where(qInputInvDtlDO.masId.eq(masId))
                .fetch();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qInputInvDtlDO.id,
                qInputInvDtlDO.sourceNo,
                qInputInvDtlDO.sourceId,
                qInputInvDtlDO.sourceLineId,
                qInputInvDtlDO.masId,
                qInputInvDtlDO.sourceLine,
                qInputInvDtlDO.itemId,
                qInputInvDtlDO.itemCode,
                qInputInvDtlDO.itemName,
                qInputInvDtlDO.itemType,
                qInputInvDtlDO.uom,
                qInputInvDtlDO.uomName,
                qInputInvDtlDO.qty,
                qInputInvDtlDO.price,
                qInputInvDtlDO.taxRate,
                qInputInvDtlDO.totalAmt,
                qInputInvDtlDO.exclTaxAmt,
                qInputInvDtlDO.taxAmt,
                qInputInvDtlDO.totalCurAmt,
                qInputInvDtlDO.exclTaxCurAmt,
                qInputInvDtlDO.taxCurAmt,
                qInputInvDtlDO.remark,
                qInputInvDtlDO.invCode,
                qInputInvDtlDO.invNo,
                qInputInvDtlDO.invType,
                qInputInvDtlDO.invDate,
                qInputInvDtlDO.invKind,
                qInputInvDtlDO.invState,
                qInputInvDtlDO.blueInvNo,
                qInputInvDtlDO.examType
        )).from(qInputInvDtlDO);
    }

}
