package com.elitesland.yst.production.fin.infr.repo.payorder;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.yst.production.fin.domain.entity.payorder.QPayOrderDtlDO;
import com.elitesland.yst.production.fin.domain.param.payorder.PayOrderDtlPageParam;
import com.elitesland.yst.production.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:45
 */
@Component
@RequiredArgsConstructor
public class PayOrderDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QPayOrderDtlDO qPayOrderDtlDO = QPayOrderDtlDO.payOrderDtlDO;

    public List<Long> queryBySourceNo(String sourceNo) {
        return jpaQueryFactory.select(qPayOrderDtlDO.masId)
                .from(qPayOrderDtlDO)
                .where(qPayOrderDtlDO.sourceNo.like("%" + sourceNo + "%"))
                .fetch();
    }

    public List<PayOrderDtlDTO> queryById(List<Long> ids) {
        return select(PayOrderDtlDTO.class)
                .where(qPayOrderDtlDO.id.in(ids))
                .fetch();
    }

    @SysCodeProc
    public List<PayOrderDtlDTO> queryByMasId(Long masId) {
        return select(PayOrderDtlDTO.class)
                .where(qPayOrderDtlDO.masId.in(masId))
                .fetch();
    }

    public void deleteByMasIds(List<Long> masIds) {
        jpaQueryFactory.delete(qPayOrderDtlDO)
                .where(qPayOrderDtlDO.masId.in(masIds))
                .execute();
    }

    public PagingVO<PayOrderDtlDTO> page(PayOrderDtlPageParam param) {
        List<Predicate> predicates = new ArrayList<>();
        if (param.getMisId() != null) {
            predicates.add(qPayOrderDtlDO.masId.eq(param.getMisId()));
        }
        JPAQuery<PayOrderDtlDTO> query = select(PayOrderDtlDTO.class).where(ExpressionUtils.allOf(predicates));
        param.setPaging(query);
        param.fillOrders(query, qPayOrderDtlDO);
        return PagingVO.<PayOrderDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qPayOrderDtlDO.id,
                qPayOrderDtlDO.masId,
                qPayOrderDtlDO.payType,
                qPayOrderDtlDO.payBank,
                qPayOrderDtlDO.payAccount,
                qPayOrderDtlDO.recBank,
                qPayOrderDtlDO.recAccount,
                qPayOrderDtlDO.sourceNo,
                qPayOrderDtlDO.sourceLine,
                qPayOrderDtlDO.sourceId,
                qPayOrderDtlDO.sourceLineId,
                qPayOrderDtlDO.realPayAmt,
                qPayOrderDtlDO.realPayCurAmt,
                qPayOrderDtlDO.totalAmt,
                qPayOrderDtlDO.totalCurAmt,
                qPayOrderDtlDO.expensesType,
                qPayOrderDtlDO.buId,
                qPayOrderDtlDO.buName,
                qPayOrderDtlDO.buCode,
                qPayOrderDtlDO.remark)
        ).from(qPayOrderDtlDO);
    }

    public List<PayOrderDtlDTO> queryByMasId(Collection<Long> masIds) {
        return select(PayOrderDtlDTO.class)
                .where(qPayOrderDtlDO.masId.in(masIds))
                .fetch();
    }
}
