package com.elitesland.yst.production.fin.provider.arorder;

import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.production.fin.Application;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.yst.production.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.yst.production.fin.domain.entity.arorder.ArOrder;
import com.elitesland.yst.production.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.yst.production.fin.param.arorder.ArOrderRpcParam;
import com.elitesland.yst.production.fin.service.aporder.ApOrderRpcService;
import com.elitesland.yst.production.fin.service.arorder.ArOrderRpcService;
import com.elitescloud.boot.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.provider.arorder
 * 应收单
 * @date 2022/5/18 15:53
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + ArOrderRpcService.PATH)
public class ArOrderRpcServiceImpl implements ArOrderRpcService {

    public final ArOrderDomainService arOrderDomainService;

    @Override
    public Long save(ArOrderRpcParam arOrderRpcParam) {
        if (CharSequenceUtil.isBlank(arOrderRpcParam.getCreateMode())) {
            throw new BusinessException("createMode不能为空");
        }
        ArOrder arOrder = ArOrderConvert.INSTANCE.convertRpc(arOrderRpcParam);
        Long resId = arOrderDomainService.save(arOrder);
        return resId;
    }
}
