package com.elitesland.yst.production.fin.repo.adjusttoorder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.fin.application.facade.param.adjusttoorder.AdjustToOrderPageParam;
import com.elitesland.yst.production.fin.application.facade.vo.adjusttoorder.AdjustToOrderVO;
import com.elitesland.yst.production.fin.entity.adjusttoorder.QAdjustToOrderDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/3/3 16:28
 */
@Component
@RequiredArgsConstructor
public class AdjustToOrderRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QAdjustToOrderDO adjustOrder = QAdjustToOrderDO.adjustToOrderDO;

    public PagingVO<AdjustToOrderVO> page(AdjustToOrderPageParam adjustOrderPageParam) {
        List<Predicate> where = where(adjustOrderPageParam);
        JPAQuery<AdjustToOrderVO> query = select(AdjustToOrderVO.class).where(ExpressionUtils.allOf(where));
        adjustOrderPageParam.setPaging(query);
        adjustOrderPageParam.fillOrders(query, adjustOrder);
        return PagingVO.<AdjustToOrderVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<AdjustToOrderVO> queryByIds(List<Long> id){
        return   select(AdjustToOrderVO.class)
                .where(adjustOrder.id.in(id))
                .fetch();
    }
    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO){
        jpaQueryFactory.update(adjustOrder)
                .set(adjustOrder.state,status)
                .set(adjustOrder.auditTime, LocalDateTime.now())
                .set(adjustOrder.auditUser,sysUserDTO.getUsername())
                .set(adjustOrder.auditUserId, sysUserDTO.getId())
                .where(adjustOrder.id.in(ids))
                .execute();
    }
    public void updateReject(List<Long> ids, String status, SysUserDTO sysUserDTO,String reason){
        jpaQueryFactory.update(adjustOrder)
                .set(adjustOrder.state,status)
                .set(adjustOrder.auditTime, LocalDateTime.now())
                .set(adjustOrder.auditUser,sysUserDTO.getUsername())
                .set(adjustOrder.auditUserId, sysUserDTO.getId())
                .set(adjustOrder.auditRejectReason,reason)
                .where(adjustOrder.id.in(ids))
                .execute();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO,String reason){
        jpaQueryFactory.update(adjustOrder)
                .set(adjustOrder.state,status)
                .set(adjustOrder.auditTime, LocalDateTime.now())
                .set(adjustOrder.auditUser,sysUserDTO.getUsername())
                .set(adjustOrder.auditUserId, sysUserDTO.getId())
                .set(adjustOrder.auditRejectReason,reason)
                .where(adjustOrder.id.in(ids))
                .execute();
    }
    public AdjustToOrderVO queryById(Long id){
        return   select(AdjustToOrderVO.class)
                .where(adjustOrder.id.eq(id))
                .fetchOne();
    }
    private List<Predicate> where(AdjustToOrderPageParam adjustOrderPageParam){
        List<Predicate> predicates = new ArrayList<>();
        if(!CollectionUtils.isEmpty(adjustOrderPageParam.getIds())){
            predicates.add(adjustOrder.id.in(adjustOrderPageParam.getIds()));
        }
        if(!CollectionUtils.isEmpty(adjustOrderPageParam.getAccTypeFrom())){
            predicates.add(adjustOrder.accTypeFrom.in(adjustOrderPageParam.getAccTypeFrom()));
        }
        if(!CollectionUtils.isEmpty(adjustOrderPageParam.getAccTypeTo())){
            predicates.add(adjustOrder.accTypeTo.in(adjustOrderPageParam.getAccTypeTo()));
        }
        if(!StringUtils.isEmpty(adjustOrderPageParam.getAccCodeFrom())){
            predicates.add(adjustOrder.accCodeFrom.eq(adjustOrderPageParam.getAccCodeFrom()));
        }
        if(!StringUtils.isEmpty(adjustOrderPageParam.getAccCodeTo())){
            predicates.add(adjustOrder.accCodeTo.eq(adjustOrderPageParam.getAccCodeTo()));
        }
        if(!CollectionUtils.isEmpty(adjustOrderPageParam.getState())){
            predicates.add(adjustOrder.state.in(adjustOrderPageParam.getState()));
        }
        if(!CollectionUtils.isEmpty(adjustOrderPageParam.getAdjReason())){
            predicates.add(adjustOrder.adjReason.in(adjustOrderPageParam.getAdjReason()));
        }
        if(!StringUtils.isEmpty(adjustOrderPageParam.getDocNo())){
            predicates.add(adjustOrder.docNo.like("%"+ adjustOrderPageParam.getDocNo()+"%"));
        }
        if(adjustOrderPageParam.getAuditTimeS()!=null&& adjustOrderPageParam.getAuditTimeE()!=null){
            predicates.add(adjustOrder.auditTime.between(adjustOrderPageParam.getAuditTimeS(), adjustOrderPageParam.getAuditTimeE()));
        }
        if(!StringUtils.isEmpty(adjustOrderPageParam.getAccNameFrom())){
            predicates.add(adjustOrder.accNameFrom.eq(adjustOrderPageParam.getAccNameFrom()));
        }
        if(!StringUtils.isEmpty(adjustOrderPageParam.getAccNameTo())){
            predicates.add(adjustOrder.accNameTo.eq(adjustOrderPageParam.getAccNameTo()));
        }
        if(adjustOrderPageParam.getTotalAmtF()!=null){
            predicates.add(adjustOrder.totalAmt.goe(adjustOrderPageParam.getTotalAmtF()));
        }
        if(adjustOrderPageParam.getTotalAmtT()!=null){
            predicates.add(adjustOrder.totalAmt.loe(adjustOrderPageParam.getTotalAmtT()));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                adjustOrder.id,
                adjustOrder.state,
                adjustOrder.type,
                adjustOrder.accCodeFrom,
                adjustOrder.accNameFrom,
                adjustOrder.accTypeFrom,
                adjustOrder.accTypeTo,
                adjustOrder.accCodeTo,
                adjustOrder.accNameTo,
                adjustOrder.auditTime,
                adjustOrder.auditRejectReason,
                adjustOrder.auditUser,
                adjustOrder.recAccTime,
                adjustOrder.docNo,
                adjustOrder.createTime,
                adjustOrder.creator,
                adjustOrder.totalAmt,
                adjustOrder.remark,
                adjustOrder.ouId,
                adjustOrder.ouCode,
                adjustOrder.ouName,
                adjustOrder.modifyTime,
                adjustOrder.modifyUserId,
                adjustOrder.updater,
                adjustOrder.adjReason
        )).from(adjustOrder);
    }
}
