package com.elitesland.yst.production.fin.rocketmq.input;

import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.fin.param.arorder.ArOrderRpcParam;
import com.elitesland.yst.production.fin.param.recorder.RecOrderRpcParam;
import com.elitesland.yst.production.fin.rocketmq.channel.FinSalMqProcessor;
import com.elitesland.yst.production.fin.service.arorder.ArOrderRpcService;
import com.elitesland.yst.production.fin.service.recorder.RecOrderRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
@Slf4j
@RequiredArgsConstructor
public class ArOrderConsumer {

    private final ArOrderRpcService arOrderRpcService;

    private final RecOrderRpcService recOrderRpcService;

    /**
     * 应收单据
     * 通道1消费订阅* 测试自定义消息   tag订阅过滤 +header过滤
     **/
    @StreamListener(value = FinSalMqProcessor.INPUT_SAL, condition = "headers['tag']=='ar'")
    public void saveArOrder(@Payload ArOrderRpcParam arOrderRpcParam, @Headers Map<?,?> headers) {
        log.info("=====================销售应收单消息信息headers={},arOrderRpcParam={}", headers, JSON.toJSONString(arOrderRpcParam));

        Long resId = arOrderRpcService.save(arOrderRpcParam);
        String sourceNo = arOrderRpcParam.getSourceNo();
        if (resId != null) {
            log.info("=====================销售应收单消息结束单号sourceNo={},headers={}", sourceNo, headers);
        } else {
            log.info("=====================销售应收单消息已消费headers={},arOrderRpcParam={}", headers, JSON.toJSONString(arOrderRpcParam));
        }

    }


    /**
     * 收款单据
     * 通道1消费订阅* 测试自定义消息   tag订阅过滤 +header过滤
     **/
    @StreamListener(value = FinSalMqProcessor.INPUT_SAL, condition = "headers['tag']=='rec'")
    public void saveRecOrder(@Payload RecOrderRpcParam recOrderRpcParam, @Headers Map<?,?> headers) {
        log.info("=====================销售收款单消息信息headers={},apOrderRpcParam={}", headers, JSON.toJSONString(recOrderRpcParam));

        Long resId = recOrderRpcService.save(recOrderRpcParam);
        String sourceNo = recOrderRpcParam.getSourceNo();
        if (resId != null) {
            log.info("=====================销售收款单消息结束单号sourceNo={},headers={}", sourceNo, headers);
        } else {
            log.info("=====================销售收款单消息已消费headers={},apOrderRpcParam={}", headers, JSON.toJSONString(recOrderRpcParam));
        }

    }
}
