package com.elitesland.yst.production.fin.rpc.system;


import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @author zhiyu.he
 * @date 2022/4/26 10:21
 */
@Service
@RequiredArgsConstructor
public class SystemRpcServiceImpl implements SystemRpcService {

    private final SysUserRpcService sysUserRpcService;

    @Override
    public SysUserDTO getUserByName(String userName) {
        ApiResult<SysUserDTO> user = sysUserRpcService.getUserByUsername(userName);
        if (user != null) {
            if (user.getData() != null) {
                return user.getData();
            } else {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "用户名称" + userName + "获取信息为空!");
            }
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "用户名称 " + userName + "获取信息为空!");
        }
    }
}
