/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.application.service.workflow.saleinv;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.production.fin.application.service.workflow.saleinv.SaleInvProcessService;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.domain.entity.saleinv.QSaleInvDO;
import com.elitesland.yst.production.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.yst.production.fin.infr.repo.saleinv.SaleInvRepoProc;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleInvProcessServiceImpl
implements SaleInvProcessService {
    private static final Logger log = LoggerFactory.getLogger(SaleInvProcessServiceImpl.class);
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final SaleInvRepoProc saleInvRepoProc;
    private final JPAQueryFactory jpaQueryFactory;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        SaleInvDTO saleInvDTO = this.saleInvRepoProc.get(id);
        if (saleInvDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QSaleInvDO saleInvDO = QSaleInvDO.saleInvDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)saleInvDO).set(saleInvDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{saleInvDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode()).set((Path)saleInvDO.procInstId, (Object)null);
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode()).set(saleInvDO.approvedTime, (Object)LocalDateTime.now()).set(saleInvDO.auditDate, (Object)LocalDateTime.now()).set(saleInvDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)saleInvDO.auditRejection, (Object)commentInfo.getComment()).set((Path)saleInvDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode()).set(saleInvDO.auditDate, (Object)LocalDateTime.now()).set(saleInvDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)saleInvDO.auditRejection, (Object)commentInfo.getComment()).set((Path)saleInvDO.auditUser, (Object)commentInfo.getUserName()).set((Path)saleInvDO.procInstId, (Object)null);
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_DOING.getValueCode()).set(saleInvDO.auditDate, (Object)LocalDateTime.now()).set(saleInvDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)saleInvDO.auditRejection, (Object)commentInfo.getComment()).set((Path)saleInvDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)saleInvDO.orderState, (Object)UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode()).set(saleInvDO.approvedTime, (Object)LocalDateTime.now()).set(saleInvDO.auditDate, (Object)LocalDateTime.now()).set(saleInvDO.auditUserId, (Object)Long.valueOf(commentInfo.getUserId())).set((Path)saleInvDO.auditUser, (Object)commentInfo.getUserName());
                break;
            }
        }
        jpaUpdateClause.execute();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        SaleInvDTO saleInvDTO = this.saleInvRepoProc.get(businessId);
        if (saleInvDTO == null) {
            throw new BusinessException("\u5355\u636e(id:" + businessId + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder().ouIds(Collections.singletonList(saleInvDTO.getOuId())).flowRoleCodes(Collections.singletonList(customParams)).build();
        List userIdsByFlowRoles = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> "" + e).collect(Collectors.toCollection(ArrayList::new));
    }

    public SaleInvProcessServiceImpl(SysUserFlowRoleRpcService sysUserFlowRoleRpcService, SaleInvRepoProc saleInvRepoProc, JPAQueryFactory jpaQueryFactory) {
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.saleInvRepoProc = saleInvRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

