/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.common;

import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysNumberGenerator {
    private static final Logger log = LoggerFactory.getLogger(SysNumberGenerator.class);
    private static final String YST_FIN = "yst-fin";
    @Autowired
    private SeqNumProvider sysNumberRuleService;

    public String generate(@NotNull String ruleCode) {
        return this.generateCode(ruleCode, null);
    }

    public String generate(@NotNull String ruleCode, @NotNull String runtimeValue) {
        return this.generateCode(ruleCode, Collections.singletonList(runtimeValue));
    }

    public String generate(@NotNull String ruleCode, @NotNull List<String> runtimeValues) {
        return this.generateCode(ruleCode, runtimeValues);
    }

    private String generateCode(String ruleCode, List<String> runtimeValues) {
        log.debug("[SysNumberGeneratorWrapper] - \u8c03\u7528\u53d1\u53f7\u5668\uff0c\u53d1\u53f7\u5668\u89c4\u5219\uff1a" + ruleCode + "; runtimeValues\uff1a" + runtimeValues);
        String code = this.sysNumberRuleService.generateCode(YST_FIN, ruleCode, runtimeValues);
        if (StringUtils.isBlank((CharSequence)code)) {
            log.error("[SysNumberGeneratorWrapper] - \u8c03\u7528\u53d1\u53f7\u5668\u5f02\u5e38\uff0c\u89c4\u5219\uff1a" + ruleCode);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7f16\u53f7\u4e3a\u7a7a\uff0c\u89c4\u5219\uff1a" + ruleCode + "\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u89c4\u5219\u914d\u7f6e\u662f\u5426\u6b63\u786e");
        }
        return code;
    }
}

