/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.domain.service.artype;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.convert.artype.ArTypeConvert;
import com.elitesland.yst.production.fin.domain.entity.artype.ArType;
import com.elitesland.yst.production.fin.domain.entity.artype.ArTypeDO;
import com.elitesland.yst.production.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.yst.production.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.yst.production.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.yst.production.fin.infr.repo.artype.ArTypeOuRepoProc;
import com.elitesland.yst.production.fin.infr.repo.artype.ArTypeRepo;
import com.elitesland.yst.production.fin.infr.repo.artype.ArTypeRepoProc;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArTypeDomainServiceImpl
implements ArTypeDomainService {
    private final ArTypeRepo arTypeRepo;
    private final ArTypeRepoProc arTypeRepoProc;
    private final ArTypeOuRepoProc arTypeOuRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ArType arType) {
        arType.checkNotNull();
        arType.setDefaultValue();
        Boolean isExistName = this.arTypeRepoProc.existsName(arType.getArTypeName());
        if (isExistName.booleanValue()) {
            throw new BusinessException("\u5e94\u6536\u5355\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Boolean isExistCode = this.arTypeRepoProc.existsCode(arType.getArTypeCode());
        if (isExistCode.booleanValue()) {
            throw new BusinessException("\u5e94\u6536\u5355\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728");
        }
        Boolean isFir = this.arTypeRepoProc.isFir();
        if (isFir.booleanValue()) {
            arType.setDefaultFlag(true);
        }
        ArTypeDO res = (ArTypeDO)this.arTypeRepo.save(ArTypeConvert.INSTANCE.convert(arType));
        return res.getId();
    }

    @Override
    public ArTypeDTO get(Long id) {
        ArTypeDTO res = this.arTypeRepoProc.get(id);
        return res;
    }

    @Override
    public PagingVO<ArTypeDTO> page(ArTypePageParam arTypePageParam) {
        List<Long> artypeIds = new ArrayList<Long>();
        if (null != arTypePageParam.getOuId()) {
            artypeIds = this.arTypeOuRepoProc.queryByOuId(arTypePageParam.getOuId());
        }
        PagingVO<ArTypeDTO> res = this.arTypeRepoProc.page(arTypePageParam, artypeIds);
        return res;
    }

    @Override
    public List<ArTypeDTO> findByIds(List<Long> ids) {
        List<ArTypeDTO> res = this.arTypeRepoProc.findByIds(ids);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateEnableFlag(List<Long> ids, boolean enable) {
        this.arTypeRepoProc.updateEnableFlag(ids, enable);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateDef(Long id) {
        this.arTypeRepoProc.updateDef();
        Long res = this.arTypeRepoProc.updateDefById(id);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(Long id) {
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArTypeDTO arTypeDTO = this.arTypeRepoProc.findById(id);
        if (arTypeDTO.getEnableFlag().booleanValue() || arTypeDTO.getDefaultFlag().booleanValue()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u672a\u542f\u7528\u7684\u6570\u636e\u548c\u975e\u9ed8\u8ba4\u7684\u6570\u636e");
        }
        Long res = this.arTypeRepoProc.del(id);
        return res;
    }

    @Override
    public List<ArTypeDTO> getList() {
        List<ArTypeDTO> res = this.arTypeRepoProc.getList();
        return res;
    }

    @Override
    public ArTypeDTO getDef() {
        ArTypeDTO res = this.arTypeRepoProc.getDef();
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long update(ArType arType) {
        arType.checkNotNull();
        Assert.notNull((Object)arType.getDefaultFlag(), (String)"defaultFlag is null", (Object[])new Object[0]);
        Assert.notNull((Object)arType.getAutoAudit(), (String)"autoAudit is null", (Object[])new Object[0]);
        Assert.notNull((Object)arType.getEnableFlag(), (String)"enableFlag is null", (Object[])new Object[0]);
        ArTypeDO res = (ArTypeDO)this.arTypeRepo.save(ArTypeConvert.INSTANCE.convert(arType));
        return res.getId();
    }

    @Override
    public Boolean queryIsAuto(Long id) {
        return this.arTypeRepoProc.queryIsAutoAudit(id);
    }

    public ArTypeDomainServiceImpl(ArTypeRepo arTypeRepo, ArTypeRepoProc arTypeRepoProc, ArTypeOuRepoProc arTypeOuRepoProc) {
        this.arTypeRepo = arTypeRepo;
        this.arTypeRepoProc = arTypeRepoProc;
        this.arTypeOuRepoProc = arTypeOuRepoProc;
    }
}

