/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.domain.service.inputinv;

import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.yst.production.fin.application.convert.inputinv.InputInvConvert;
import com.elitesland.yst.production.fin.application.convert.inputinv.InputInvDtlConvert;
import com.elitesland.yst.production.fin.application.facade.param.inputInv.InputInvParam;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.domain.entity.inputinv.InputInv;
import com.elitesland.yst.production.fin.domain.entity.inputinv.InputInvDO;
import com.elitesland.yst.production.fin.domain.entity.inputinv.InputInvDtl;
import com.elitesland.yst.production.fin.domain.entity.inputinv.InputInvDtlDO;
import com.elitesland.yst.production.fin.domain.param.inputinv.InputInvPageParam;
import com.elitesland.yst.production.fin.domain.service.inputinv.InputInvDomainService;
import com.elitesland.yst.production.fin.infr.dto.inputinv.InputInvDTO;
import com.elitesland.yst.production.fin.infr.dto.inputinv.InputInvDtlDTO;
import com.elitesland.yst.production.fin.infr.factory.inputinv.InputInvFactory;
import com.elitesland.yst.production.fin.infr.repo.inputinv.InputInvDtlRepo;
import com.elitesland.yst.production.fin.infr.repo.inputinv.InputInvDtlRepoProc;
import com.elitesland.yst.production.fin.infr.repo.inputinv.InputInvRepo;
import com.elitesland.yst.production.fin.infr.repo.inputinv.InputInvRepoProc;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InputInvDomainServiceImpl
implements InputInvDomainService {
    private final InputInvRepoProc inputInvRepoProc;
    private final InputInvRepo inputInvRepo;
    private final InputInvFactory inputInvFactory;
    private final InputInvDtlRepoProc inputInvDtlRepoProc;
    private final InputInvDtlRepo inputInvDtlRepo;
    private final SeqNumProvider sysNumberRuleService;
    private final String message = "\u5df2\u5b58\u5728\u7684\u53d1\u7968\u53f7\u7801,\u8bf7\u68c0\u67e5!";

    @Override
    public PagingVO<InputInvDTO> page(InputInvPageParam param) {
        return this.inputInvFactory.payOrderPage(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> deleteByIds(List<Long> ids) {
        List<InputInvDTO> inputInvDTOS = this.inputInvRepoProc.queryByIds(ids);
        inputInvDTOS.forEach(dto -> {
            if (!dto.getOrderState().equals(UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u72b6\u6001\u4e3a\u8349\u7a3f\u7684\u8fdb\u9879\u53d1\u7968!");
            }
        });
        this.inputInvRepoProc.deleteByIds(ids);
        this.inputInvDtlRepoProc.deleteByMasId(ids);
        return ids;
    }

    @Override
    public InputInvDTO queryById(Long id, Boolean flag) {
        if (flag.booleanValue()) {
            InputInvDTO inputInvDTO = this.inputInvRepoProc.queryById(id);
            List<InputInvDtlDTO> inputInvDtlDTOS = this.inputInvDtlRepoProc.queryByMasId(id);
            inputInvDTO.setDtlDTOList(inputInvDtlDTOS);
            return inputInvDTO;
        }
        return this.inputInvRepoProc.queryById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(InputInv inputInv) {
        List<String> invNo = inputInv.getDtlList().stream().map(InputInvDtl::getInvNo).collect(Collectors.toList());
        inputInv.checkInvNo();
        inputInv.checkNotNull();
        if (inputInv.getId() != null) {
            inputInv.checkOrderState();
            Boolean aBoolean = this.inputInvDtlRepoProc.checkUpdate(invNo, inputInv.getId());
            if (aBoolean.booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u5b58\u5728\u7684\u53d1\u7968\u53f7\u7801,\u8bf7\u68c0\u67e5!");
            }
        } else {
            Boolean aBoolean = this.inputInvDtlRepoProc.checkAdd(invNo);
            if (aBoolean.booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u5b58\u5728\u7684\u53d1\u7968\u53f7\u7801,\u8bf7\u68c0\u67e5!");
            }
            String inputNo = this.sysNumberRuleService.generateCode("yst-fin", "JXFP", null);
            inputInv.setInvRegNo(inputNo);
        }
        inputInv.setOrderState(UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode());
        return this.updateOrSave(inputInv).getId();
    }

    private InputInvDO updateOrSave(InputInv inputInv) {
        InputInvDO inputInvDO = InputInvConvert.INSTANCE.convertToDo(inputInv);
        if (inputInv.getId() != null) {
            this.inputInvDtlRepoProc.deleteByMasId(List.of(inputInv.getId()));
        }
        InputInvDO save = (InputInvDO)this.inputInvRepo.save(inputInvDO);
        List<InputInvDtlDO> inputInvDtlDOS = InputInvDtlConvert.INSTANCE.convertToDO(inputInv.getDtlList());
        inputInvDtlDOS.forEach(dtl -> dtl.setMasId(save.getId()));
        this.inputInvDtlRepo.saveAll(inputInvDtlDOS);
        return save;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long submit(InputInv inputInv) {
        List<String> invNo = inputInv.getDtlList().stream().map(InputInvDtl::getInvNo).collect(Collectors.toList());
        inputInv.checkInvNo();
        inputInv.checkNotNull();
        inputInv.count();
        if (inputInv.getId() != null) {
            inputInv.checkOrderState();
            aBoolean = this.inputInvDtlRepoProc.checkUpdate(invNo, inputInv.getId());
            if (aBoolean.booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u5b58\u5728\u7684\u53d1\u7968\u53f7\u7801,\u8bf7\u68c0\u67e5!");
            }
        } else {
            aBoolean = this.inputInvDtlRepoProc.checkAdd(invNo);
            if (aBoolean.booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u5b58\u5728\u7684\u53d1\u7968\u53f7\u7801,\u8bf7\u68c0\u67e5!");
            }
            String inputNo = this.sysNumberRuleService.generateCode("yst-fin", "JXFP", null);
            inputInv.setInvRegNo(inputNo);
        }
        inputInv.setOrderState(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode());
        InputInvDO inputInvDO = this.updateOrSave(inputInv);
        return inputInvDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approved(Long id, SysUserDTO user) {
        this.inputInvRepoProc.updateAudit(id, null, user);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reject(InputInvParam param, SysUserDTO user) {
        this.inputInvRepoProc.updateAudit(param.getId(), param.getAuditRejection(), user);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateWorkInfo(ProcessInfo processInfo, Long resId) {
        this.inputInvRepoProc.updateWorkInfo(processInfo, resId);
    }

    public InputInvDomainServiceImpl(InputInvRepoProc inputInvRepoProc, InputInvRepo inputInvRepo, InputInvFactory inputInvFactory, InputInvDtlRepoProc inputInvDtlRepoProc, InputInvDtlRepo inputInvDtlRepo, SeqNumProvider sysNumberRuleService) {
        this.inputInvRepoProc = inputInvRepoProc;
        this.inputInvRepo = inputInvRepo;
        this.inputInvFactory = inputInvFactory;
        this.inputInvDtlRepoProc = inputInvDtlRepoProc;
        this.inputInvDtlRepo = inputInvDtlRepo;
        this.sysNumberRuleService = sysNumberRuleService;
    }
}

