/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.domain.service.recorder;

import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.yst.production.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.yst.production.fin.application.convert.recorder.RecOrderDtlConvert;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.domain.entity.recorder.RecOrder;
import com.elitesland.yst.production.fin.domain.entity.recorder.RecOrderDO;
import com.elitesland.yst.production.fin.domain.entity.recorder.RecOrderDtlDO;
import com.elitesland.yst.production.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.yst.production.fin.domain.param.recorder.RecOrderParam;
import com.elitesland.yst.production.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.yst.production.fin.infr.dto.common.ArVerDTO;
import com.elitesland.yst.production.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.yst.production.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.elitesland.yst.production.fin.infr.factory.recorder.RecOrderFactory;
import com.elitesland.yst.production.fin.infr.repo.recorder.RecOrderDtlRepo;
import com.elitesland.yst.production.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.yst.production.fin.infr.repo.recorder.RecOrderRepo;
import com.elitesland.yst.production.fin.infr.repo.recorder.RecOrderRepoProc;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecOrderDomainServiceImpl
implements RecOrderDomainService {
    private final RecOrderRepoProc recOrderRepoProc;
    private final RecOrderFactory recOrderFactory;
    private final RecOrderRepo recOrderRepo;
    private final RecOrderDtlRepoProc recOrderDtlRepoProc;
    private final RecOrderDtlRepo recOrderDtlRepo;
    private final SeqNumProvider sysNumberRuleService;

    @Override
    public PagingVO<RecOrderDTO> page(RecOrderPageParam param) {
        if (param.getReDateStart() == null || param.getReDateEnd() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u6536\u6b3e\u65e5\u671f!");
        }
        return this.recOrderFactory.recOrderPage(param);
    }

    @Override
    public RecOrderDTO queryById(Long id, Boolean flag) {
        if (flag.booleanValue()) {
            RecOrderDTO payOrderDTO = this.recOrderRepoProc.queryById(id);
            List<RecOrderDtlDTO> recOrderDtlDTOS = this.recOrderDtlRepoProc.queryByMasId(id);
            payOrderDTO.setDtlDTOS(recOrderDtlDTOS);
            return payOrderDTO;
        }
        return this.recOrderRepoProc.queryById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> deleteByIds(List<Long> ids) {
        List<RecOrderDTO> recOrderDTOS = this.recOrderRepoProc.queryByIds(ids);
        recOrderDTOS.forEach(dto -> {
            if (!dto.getOrderState().equals(UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u72b6\u6001\u4e3a\u8349\u7a3f\u7684\u6536\u6b3e\u5355!");
            }
        });
        this.recOrderRepoProc.deleteById(ids);
        this.recOrderDtlRepoProc.deleteByMasId(ids);
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(RecOrder recOrder) {
        if (recOrder.getId() != null) {
            recOrder.checkOrderState();
        } else {
            String recOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "SKD", null);
            recOrder.setRecOrderNo(recOrderNo);
        }
        if (recOrder.getVerAmt() == null) {
            recOrder.defaultVer();
        }
        recOrder.checkNotNull(recOrder.getCreateMode());
        if (!recOrder.getCreateMode().equals(UdcEnum.FIN_REC_DOC_CLS_MANU.getValueCode())) {
            if (recOrder.getId() == null) {
                recOrder.setSoDef();
                recOrder.checkDtl(false);
                recOrder.countBySo();
                recOrder.checkTotalMoney();
            }
        } else {
            recOrder.checkTotalMoney();
        }
        recOrder.setOrderState(UdcEnum.COM_APPLY_STATUS_DRAFT.getValueCode());
        return this.updateOrSave(recOrder).getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long submit(RecOrder recOrder, Boolean auto) {
        if (recOrder.getId() != null) {
            recOrder.checkOrderState();
        } else {
            String payOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "SKD", null);
            recOrder.setRecOrderNo(payOrderNo);
        }
        recOrder.checkNotNull(recOrder.getCreateMode());
        if (!recOrder.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_MANU.getValueCode())) {
            recOrder.checkTotalMoney();
        }
        recOrder.checkMoney();
        recOrder.checkDtl(true);
        if (recOrder.getVerAmt() == null) {
            recOrder.defaultVer();
        }
        if (auto.booleanValue()) {
            recOrder.setOrderState(UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode());
        } else {
            recOrder.setOrderState(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode());
        }
        RecOrderDO recOrderDO = this.updateOrSave(recOrder);
        return recOrderDO.getId();
    }

    @Override
    public List<RecOrderDTO> queryByRecTypeId(List<Long> recTypeId) {
        return this.recOrderRepoProc.queryByRecTypeId(recTypeId);
    }

    @Override
    public List<RecOrderDTO> queryByParam(RecOrderParam recOrderParam) {
        return this.recOrderRepoProc.getRecOrderList(recOrderParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Long id, BigDecimal amt) {
        ArVerDTO arVerDTO = this.recOrderRepoProc.queryVerAmtById(id);
        BigDecimal totalAmt = arVerDTO.getTotalAmt();
        if (arVerDTO.getVerAmt().add(amt).compareTo(totalAmt) > 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u6838\u9500\u91d1\u989d\u5927\u4e8e\u6536\u6b3e\u5355\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u8f93\u5165");
        }
        arVerDTO.setAmtAndVerState(amt);
        long rows = this.recOrderRepoProc.updateVerAmt(arVerDTO);
        if (rows == 0L) {
            throw new BusinessException("\u6536\u6b3e\u5355\u5355\u66f4\u65b0\u5df2\u6838\u9500\u91d1\u989d\u5931\u8d25");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        this.recOrderRepoProc.updateWorkInfo(processInfo, id);
    }

    private RecOrderDO updateOrSave(RecOrder recOrder) {
        RecOrderDO recOrderDO = RecOrderConvert.INSTANCE.convertToDo(recOrder);
        if (recOrder.getId() != null) {
            this.recOrderDtlRepoProc.deleteByMasIds(List.of(recOrder.getId()));
        } else {
            recOrderDO.setAuditDataVersion(0);
        }
        RecOrderDO save = (RecOrderDO)this.recOrderRepo.save(recOrderDO);
        List<RecOrderDtlDO> recOrderDtlDOS = RecOrderDtlConvert.INSTANCE.convertToDO(recOrder.getDtlList());
        recOrderDtlDOS.forEach(dtl -> dtl.setMasId(save.getId()));
        this.recOrderDtlRepo.saveAll(recOrderDtlDOS);
        return save;
    }

    public RecOrderDomainServiceImpl(RecOrderRepoProc recOrderRepoProc, RecOrderFactory recOrderFactory, RecOrderRepo recOrderRepo, RecOrderDtlRepoProc recOrderDtlRepoProc, RecOrderDtlRepo recOrderDtlRepo, SeqNumProvider sysNumberRuleService) {
        this.recOrderRepoProc = recOrderRepoProc;
        this.recOrderFactory = recOrderFactory;
        this.recOrderRepo = recOrderRepo;
        this.recOrderDtlRepoProc = recOrderDtlRepoProc;
        this.recOrderDtlRepo = recOrderDtlRepo;
        this.sysNumberRuleService = sysNumberRuleService;
    }
}

