/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.infr.repo.paytype;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.domain.entity.paytype.QPayTypeDO;
import com.elitesland.yst.production.fin.domain.param.paytype.PayTypePageParam;
import com.elitesland.yst.production.fin.infr.dto.paytype.PayTypeDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PayTypeRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPayTypeDO qPayTypeDO = QPayTypeDO.payTypeDO;

    public PagingVO<PayTypeDTO> page(PayTypePageParam payTypeParam, List<Long> ids) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)payTypeParam.getPayTypeCode())) {
            predicates.add(this.qPayTypeDO.payTypeCode.like("%" + payTypeParam.getPayTypeCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)payTypeParam.getPayTypeName())) {
            predicates.add(this.qPayTypeDO.payTypeName.like("%" + payTypeParam.getPayTypeName() + "%"));
        }
        if (!CollUtil.isEmpty(ids)) {
            predicates.add(this.qPayTypeDO.id.in(ids));
        }
        predicates.add(this.qPayTypeDO.deleteFlag.eq((Object)0));
        JPAQuery query = (JPAQuery)this.select(PayTypeDTO.class).where(ExpressionUtils.allOf(predicates));
        payTypeParam.setPaging(query);
        payTypeParam.fillOrders(query, this.qPayTypeDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public PayTypeDTO defaultValue() {
        return (PayTypeDTO)((JPAQuery)((JPAQuery)this.select(PayTypeDTO.class).where((Predicate)this.qPayTypeDO.defaultFlag.isTrue())).where((Predicate)this.qPayTypeDO.enableFlag.isTrue())).fetchOne();
    }

    public List<PayTypeDTO> findAll() {
        return ((JPAQuery)this.select(PayTypeDTO.class).where((Predicate)this.qPayTypeDO.enableFlag.isTrue())).fetch();
    }

    public Long updateDefaultById(Long id, Boolean isDefault) {
        return this.jpaQueryFactory.update((EntityPath)this.qPayTypeDO).set((Path)this.qPayTypeDO.defaultFlag, (Object)isDefault).where(new Predicate[]{this.qPayTypeDO.id.eq((Object)id)}).execute();
    }

    public void updateDefault() {
        this.jpaQueryFactory.update((EntityPath)this.qPayTypeDO).set((Path)this.qPayTypeDO.defaultFlag, (Object)false).where(new Predicate[]{this.qPayTypeDO.defaultFlag.isTrue()}).execute();
    }

    public Boolean existPayCode(String payCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qPayTypeDO.payTypeCode).from((EntityPath)this.qPayTypeDO)).where((Predicate)this.qPayTypeDO.payTypeCode.eq((Object)payCode))).fetchCount() > 0L;
    }

    public Boolean existPayName(String payName) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qPayTypeDO.payTypeName).from((EntityPath)this.qPayTypeDO)).where((Predicate)this.qPayTypeDO.payTypeName.eq((Object)payName))).fetchCount() > 0L;
    }

    public List<PayTypeDTO> findByIds(Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.select(PayTypeDTO.class).where((Predicate)this.qPayTypeDO.id.in(ids))).where((Predicate)this.qPayTypeDO.deleteFlag.eq((Object)0))).fetch();
    }

    public Boolean isFirst() {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qPayTypeDO.id).from((EntityPath)this.qPayTypeDO)).where((Predicate)this.qPayTypeDO.deleteFlag.eq((Object)0))).fetchCount() > 0L;
    }

    public void deleteByIds(List<Long> ids) {
        this.jpaQueryFactory.delete((EntityPath)this.qPayTypeDO).where(new Predicate[]{this.qPayTypeDO.id.in(ids)}).execute();
    }

    public void updateEnable(List<Long> ids, Boolean trueOrFalse) {
        this.jpaQueryFactory.update((EntityPath)this.qPayTypeDO).set((Path)this.qPayTypeDO.enableFlag, (Object)trueOrFalse).where(new Predicate[]{this.qPayTypeDO.id.in(ids)}).execute();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qPayTypeDO.id, this.qPayTypeDO.payTypeCode, this.qPayTypeDO.payTypeName, this.qPayTypeDO.defaultFlag, this.qPayTypeDO.enableFlag})).from((EntityPath)this.qPayTypeDO);
    }

    public PayTypeRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

