/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.infr.repo.saleinv;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.yst.production.fin.domain.entity.saleinv.QSaleInvdDtlDO;
import com.elitesland.yst.production.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.yst.production.fin.infr.dto.saleinv.SaleInvdDtlDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SaleInvdDtlRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QSaleInvdDtlDO qSaleInvdDtlDO = QSaleInvdDtlDO.saleInvdDtlDO;

    public List<Long> getMasId(SaleInvPageParam saleInvPageParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getInvNo())) {
            predicates.add(this.qSaleInvdDtlDO.invNo.like("%" + saleInvPageParam.getInvNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getBlueInvNo())) {
            predicates.add(this.qSaleInvdDtlDO.blueInvNo.like("%" + saleInvPageParam.getBlueInvNo() + "%"));
        }
        if (null != saleInvPageParam.getInvDateStart() && null != saleInvPageParam.getInvDateEnd()) {
            predicates.add(this.qSaleInvdDtlDO.invDate.between((Comparable)saleInvPageParam.getInvDateStart(), (Comparable)saleInvPageParam.getInvDateEnd()));
        }
        if (null != saleInvPageParam.getTotalAmtStart()) {
            predicates.add(this.qSaleInvdDtlDO.totalAmt.goe((Number)saleInvPageParam.getTotalAmtStart()));
        }
        if (null != saleInvPageParam.getTotalAmtEnd()) {
            predicates.add(this.qSaleInvdDtlDO.totalAmt.loe((Number)saleInvPageParam.getTotalAmtEnd()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getRedState())) {
            predicates.add(this.qSaleInvdDtlDO.redState.eq((Object)saleInvPageParam.getRedState()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getInvState())) {
            predicates.add(this.qSaleInvdDtlDO.invState.eq((Object)saleInvPageParam.getInvState()));
        }
        predicates.add(this.qSaleInvdDtlDO.deleteFlag.eq((Object)0));
        List ids = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qSaleInvdDtlDO.masId).from((EntityPath)this.qSaleInvdDtlDO)).where(ExpressionUtils.allOf(predicates))).fetch();
        return ids;
    }

    public List<SaleInvdDtlDTO> getList(Long masId) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (null != masId) {
            predicates.add(this.qSaleInvdDtlDO.masId.eq((Object)masId));
        }
        predicates.add(this.qSaleInvdDtlDO.deleteFlag.eq((Object)0));
        List res = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleInvdDtlDTO.class, (Expression[])new Expression[]{this.qSaleInvdDtlDO.masId, this.qSaleInvdDtlDO.invNo, this.qSaleInvdDtlDO.flowNo, this.qSaleInvdDtlDO.invCode, this.qSaleInvdDtlDO.checkCode, this.qSaleInvdDtlDO.blueInvCode, this.qSaleInvdDtlDO.blueInvNo, this.qSaleInvdDtlDO.redState, this.qSaleInvdDtlDO.invPdfUrl, this.qSaleInvdDtlDO.invFailCause, this.qSaleInvdDtlDO.invDate, this.qSaleInvdDtlDO.totalAmt, this.qSaleInvdDtlDO.invState})).from((EntityPath)this.qSaleInvdDtlDO)).where(ExpressionUtils.allOf(predicates))).fetch();
        return res;
    }

    public void delByMasId(List<Long> masIds) {
        if (CollUtil.isEmpty(masIds)) {
            return;
        }
        this.jpaQueryFactory.delete((EntityPath)this.qSaleInvdDtlDO).where(new Predicate[]{this.qSaleInvdDtlDO.masId.in(masIds)}).execute();
    }

    public SaleInvdDtlRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

