/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.repo.adjustorder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.fin.application.facade.param.adjustorder.AdjustOrderPageParam;
import com.elitesland.yst.production.fin.application.facade.vo.adjustorder.AdjustOrderVO;
import com.elitesland.yst.production.fin.entity.adjustorder.QAdjustOrderDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AdjustOrderRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QAdjustOrderDO adjustOrder = QAdjustOrderDO.adjustOrderDO;

    public PagingVO<AdjustOrderVO> page(AdjustOrderPageParam adjustOrderPageParam) {
        List<Predicate> where = this.where(adjustOrderPageParam);
        JPAQuery query = (JPAQuery)this.select(AdjustOrderVO.class).where(ExpressionUtils.allOf(where));
        adjustOrderPageParam.setPaging(query);
        adjustOrderPageParam.fillOrders(query, this.adjustOrder);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public List<AdjustOrderVO> queryByIds(List<Long> id) {
        return ((JPAQuery)this.select(AdjustOrderVO.class).where((Predicate)this.adjustOrder.id.in(id))).fetch();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO) {
        this.jpaQueryFactory.update((EntityPath)this.adjustOrder).set((Path)this.adjustOrder.state, (Object)status).set(this.adjustOrder.auditTime, (Object)LocalDateTime.now()).set((Path)this.adjustOrder.auditUser, (Object)sysUserDTO.getUsername()).set(this.adjustOrder.auditUserId, (Object)sysUserDTO.getId()).where(new Predicate[]{this.adjustOrder.id.in(ids)}).execute();
    }

    public void updateReject(List<Long> ids, String status, SysUserDTO sysUserDTO, String reason) {
        this.jpaQueryFactory.update((EntityPath)this.adjustOrder).set((Path)this.adjustOrder.state, (Object)status).set(this.adjustOrder.auditTime, (Object)LocalDateTime.now()).set((Path)this.adjustOrder.auditUser, (Object)sysUserDTO.getUsername()).set(this.adjustOrder.auditUserId, (Object)sysUserDTO.getId()).set((Path)this.adjustOrder.auditRejectReason, (Object)reason).where(new Predicate[]{this.adjustOrder.id.in(ids)}).execute();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO, String reason) {
        this.jpaQueryFactory.update((EntityPath)this.adjustOrder).set((Path)this.adjustOrder.state, (Object)status).set(this.adjustOrder.auditTime, (Object)LocalDateTime.now()).set((Path)this.adjustOrder.auditUser, (Object)sysUserDTO.getUsername()).set(this.adjustOrder.auditUserId, (Object)sysUserDTO.getId()).set((Path)this.adjustOrder.auditRejectReason, (Object)reason).where(new Predicate[]{this.adjustOrder.id.in(ids)}).execute();
    }

    public AdjustOrderVO queryById(Long id) {
        return (AdjustOrderVO)((JPAQuery)this.select(AdjustOrderVO.class).where((Predicate)this.adjustOrder.id.eq((Object)id))).fetchOne();
    }

    private List<Predicate> where(AdjustOrderPageParam adjustOrderPageParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!CollectionUtils.isEmpty(adjustOrderPageParam.getIds())) {
            predicates.add((Predicate)this.adjustOrder.id.in(adjustOrderPageParam.getIds()));
        }
        if (!CollectionUtils.isEmpty(adjustOrderPageParam.getState())) {
            predicates.add((Predicate)this.adjustOrder.state.in(adjustOrderPageParam.getState()));
        }
        if (!CollectionUtils.isEmpty(adjustOrderPageParam.getAdjType())) {
            predicates.add((Predicate)this.adjustOrder.adjType.in(adjustOrderPageParam.getAdjType()));
        }
        if (!CollectionUtils.isEmpty(adjustOrderPageParam.getAdjReason())) {
            predicates.add((Predicate)this.adjustOrder.adjReason.in(adjustOrderPageParam.getAdjReason()));
        }
        if (!StringUtils.isEmpty((CharSequence)adjustOrderPageParam.getDocNo())) {
            predicates.add((Predicate)this.adjustOrder.docNo.like("%" + adjustOrderPageParam.getDocNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)adjustOrderPageParam.getAccName())) {
            predicates.add((Predicate)this.adjustOrder.accName.eq((Object)adjustOrderPageParam.getAccName()));
        }
        if (!StringUtils.isEmpty((CharSequence)adjustOrderPageParam.getAccCode())) {
            predicates.add((Predicate)this.adjustOrder.accCode.eq((Object)adjustOrderPageParam.getAccCode()));
        }
        if (adjustOrderPageParam.getAuditTimeS() != null && adjustOrderPageParam.getAuditTimeE() != null) {
            predicates.add((Predicate)this.adjustOrder.auditTime.between((Comparable)adjustOrderPageParam.getAuditTimeS(), (Comparable)adjustOrderPageParam.getAuditTimeE()));
        }
        if (adjustOrderPageParam.getTotalAmtF() != null) {
            predicates.add((Predicate)this.adjustOrder.totalAmt.goe((Number)adjustOrderPageParam.getTotalAmtF()));
        }
        if (adjustOrderPageParam.getTotalAmtT() != null) {
            predicates.add((Predicate)this.adjustOrder.totalAmt.loe((Number)adjustOrderPageParam.getTotalAmtT()));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.adjustOrder.id, this.adjustOrder.state, this.adjustOrder.type, this.adjustOrder.accCode, this.adjustOrder.accName, this.adjustOrder.accType, this.adjustOrder.auditTime, this.adjustOrder.auditRejectReason, this.adjustOrder.auditUser, this.adjustOrder.recAccTime, this.adjustOrder.docNo, this.adjustOrder.createTime, this.adjustOrder.creator, this.adjustOrder.totalAmt, this.adjustOrder.remark, this.adjustOrder.ouId, this.adjustOrder.ouCode, this.adjustOrder.ouName, this.adjustOrder.modifyTime, this.adjustOrder.modifyUserId, this.adjustOrder.updater, this.adjustOrder.adjReason, this.adjustOrder.adjType})).from((EntityPath)this.adjustOrder);
    }

    public AdjustOrderRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

