/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.rocketmq.input;

import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.fin.param.arorder.ArOrderRpcParam;
import com.elitesland.yst.production.fin.param.recorder.RecOrderRpcParam;
import com.elitesland.yst.production.fin.service.arorder.ArOrderRpcService;
import com.elitesland.yst.production.fin.service.recorder.RecOrderRpcService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
public class ArOrderConsumer {
    private static final Logger log = LoggerFactory.getLogger(ArOrderConsumer.class);
    private final ArOrderRpcService arOrderRpcService;
    private final RecOrderRpcService recOrderRpcService;

    @StreamListener(value="yst-corder-fin-input", condition="headers['tag']=='ar'")
    public void saveArOrder(@Payload ArOrderRpcParam arOrderRpcParam, @Headers Map<?, ?> headers) {
        log.info("=====================\u9500\u552e\u5e94\u6536\u5355\u6d88\u606f\u4fe1\u606fheaders={},arOrderRpcParam={}", headers, (Object)JSON.toJSONString((Object)arOrderRpcParam));
        Long resId = this.arOrderRpcService.save(arOrderRpcParam);
        String sourceNo = arOrderRpcParam.getSourceNo();
        if (resId != null) {
            log.info("=====================\u9500\u552e\u5e94\u6536\u5355\u6d88\u606f\u7ed3\u675f\u5355\u53f7sourceNo={},headers={}", (Object)sourceNo, headers);
        } else {
            log.info("=====================\u9500\u552e\u5e94\u6536\u5355\u6d88\u606f\u5df2\u6d88\u8d39headers={},arOrderRpcParam={}", headers, (Object)JSON.toJSONString((Object)arOrderRpcParam));
        }
    }

    @StreamListener(value="yst-corder-fin-input", condition="headers['tag']=='rec'")
    public void saveRecOrder(@Payload RecOrderRpcParam recOrderRpcParam, @Headers Map<?, ?> headers) {
        log.info("=====================\u9500\u552e\u6536\u6b3e\u5355\u6d88\u606f\u4fe1\u606fheaders={},apOrderRpcParam={}", headers, (Object)JSON.toJSONString((Object)recOrderRpcParam));
        Long resId = this.recOrderRpcService.save(recOrderRpcParam);
        String sourceNo = recOrderRpcParam.getSourceNo();
        if (resId != null) {
            log.info("=====================\u9500\u552e\u6536\u6b3e\u5355\u6d88\u606f\u7ed3\u675f\u5355\u53f7sourceNo={},headers={}", (Object)sourceNo, headers);
        } else {
            log.info("=====================\u9500\u552e\u6536\u6b3e\u5355\u6d88\u606f\u5df2\u6d88\u8d39headers={},apOrderRpcParam={}", headers, (Object)JSON.toJSONString((Object)recOrderRpcParam));
        }
    }

    public ArOrderConsumer(ArOrderRpcService arOrderRpcService, RecOrderRpcService recOrderRpcService) {
        this.arOrderRpcService = arOrderRpcService;
        this.recOrderRpcService = recOrderRpcService;
    }
}

