package com.elitesland.yst.production.fin.application.web.aptype;

import com.elitesland.yst.production.fin.application.facade.param.aptype.ApTypeOuSaveParam;
import com.elitesland.yst.production.fin.application.facade.param.aptype.ApTypeParam;
import com.elitesland.yst.production.fin.application.facade.vo.aptype.ApTypeOuVO;
import com.elitesland.yst.production.fin.application.facade.vo.aptype.ApTypeVO;
import com.elitesland.yst.production.fin.application.service.aptype.ApTypeOuService;
import com.elitesland.yst.production.fin.application.service.aptype.ApTypeService;
import com.elitesland.yst.production.fin.domain.param.aptype.ApTypeOuPageParam;
import com.elitesland.yst.production.fin.domain.param.aptype.ApTypePageParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.fin.application.web.aptype
 * @date 2022/3/11 15:32
 */
@RestController
@RequestMapping("/fin/apType")
@RequiredArgsConstructor
@Api(value = "应付单类型定义", tags = {"应付单类型定义"})
public class ApTypeController {

    public final ApTypeService apTypeService;
    public final ApTypeOuService apTypeOuService;


    @GetMapping("getDef")
    @ApiOperation("获取应付单类型默认")
    public ApiResult<ApTypeVO> getDef() {
        ApiResult<ApTypeVO> res = apTypeService.getDef();
        return res;
    }

    @GetMapping("getList")
    @ApiOperation("获取应付单类型列表")
    public ApiResult<List<ApTypeVO>> getList() {
        ApiResult<List<ApTypeVO>> res = apTypeService.getList();
        return res;
    }

    @PostMapping("save")
    @ApiOperation("新增应付单类型")
    public ApiResult<Long> save(@RequestBody ApTypeParam apTypeParam) {
        ApiResult<Long> save = apTypeService.save(apTypeParam);
        return save;
    }

    @PostMapping("page")
    @ApiOperation("应付单类型分页列表")
    public ApiResult<PagingVO<ApTypeVO>> page(@RequestBody ApTypePageParam apTypeParam) {
        PagingVO<ApTypeVO> page = apTypeService.page(apTypeParam);
        return ApiResult.ok(page);
    }

    @PostMapping("enable")
    @ApiOperation("启用/状态批量修改")
    public ApiResult<Boolean> enable(@RequestBody List<Long> ids) {
        ApiResult<Boolean> res = apTypeService.updateEnableFlag(ids, true);
        return res;
    }

    @PostMapping("stop")
    @ApiOperation("停用/状态批量修改")
    public ApiResult<Boolean> stop(@RequestBody List<Long> ids) {
        ApiResult<Boolean> res = apTypeService.updateEnableFlag(ids, false);
        return res;
    }

    @PostMapping("ouPage")
    @ApiOperation("分页查询应付单类型对应的公司")
    public ApiResult<PagingVO<ApTypeOuVO>> page(@RequestBody ApTypeOuPageParam apTypeOuParam) {
        PagingVO<ApTypeOuVO> res = apTypeOuService.page(apTypeOuParam);
        return ApiResult.ok(res);
    }

    @PostMapping("updateDef/{id}")
    @ApiOperation("设置默认状态")
    public ApiResult<Long> updateDef(@PathVariable("id") Long id) {
        ApiResult<Long> res = apTypeService.updateDef(id);
        return res;
    }

    @DeleteMapping("del/{id}")
    @ApiOperation("删除应付单类型")
    public ApiResult<Long> del(@PathVariable("id") Long id) {
        ApiResult<Long> res = apTypeService.del(id);
        return res;
    }

    @ApiOperation("添加分配公司")
    @PostMapping("addOu")
    public ApiResult<Boolean> addOu(@RequestBody ApTypeOuSaveParam apTypeOuSaveParam) {
        ApiResult<Boolean> res = apTypeOuService.addOu(apTypeOuSaveParam);
        return res;
    }

    @PostMapping("cancelOu")
    @ApiOperation("取消分配公司")
    public ApiResult<Boolean> cancelOu(@RequestBody List<Long> ids) {
        ApiResult<Boolean> res = apTypeOuService.cancelOu(ids);
        return res;
    }

}
