package com.elitesland.yst.production.fin.domain.entity.saleinv;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-5-6
 * @desc : 销售发票明细
 */
@Entity
@Table(name="sale_inv_dtl")
@org.hibernate.annotations.Table(appliesTo = "sale_inv_dtl", comment = "销售发票明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SaleInvDtlDO extends BaseModel implements Serializable {


    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '关联id'")
    private Long masId;

    @Column(name = "tax_name", columnDefinition = "varchar(200) comment '应税货物或劳务、服务名称'")
    private String taxName;

    @Column(name = "tax_code", columnDefinition = "varchar(100) comment '税收分类编码'")
    private String taxCode;

    @Column(name = "inv_nature", columnDefinition = "varchar(100) comment '发票行性质'")
    private String invNature;

    @Column(name = "source_no", columnDefinition = "varchar(20) comment '来源单号'")
    private String sourceNo;

    @Column(name = "source_id", columnDefinition = "bigint(20) comment '来源单号ID'")
    private Long sourceId;

    @Column(name = "source_line", columnDefinition = "int(10) comment '来源行号'")
    private Integer sourceLine;

    @Column(name = "source_line_id", columnDefinition = "bigint(20) comment '来源行号ID'")
    private Long sourceLineId;

    @Column(name = "item_id", columnDefinition = "bigint(20) comment '商品ID'")
    private Long itemId;

    @Column(name = "item_name", columnDefinition = "varchar(200) comment '商品名称'")
    private String itemName;

    @Column(name = "item_code", columnDefinition = "varchar(20) comment '商品编码'")
    private String itemCode;

    @Column(name = "item_type", columnDefinition = "varchar(200) comment '规格型号'")
    private String itemType;

    @Column(name = "uom", columnDefinition = "varchar(20) comment '计量单位'")
    private String uom;

    @Column(name = "uom_name", columnDefinition = "varchar(20) comment '计量单位名称'")
    private String uomName;

    @Column(name = "qty", columnDefinition = "decimal(16,4) comment '数量'")
    private BigDecimal qty;

    @Column(name = "price", columnDefinition = "decimal(18,8) comment '含税单价'")
    private BigDecimal price;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额'")
    private BigDecimal totalAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "tax_rate", columnDefinition = "decimal(18,8) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "tax_amt", columnDefinition = "decimal(18,8) comment '税额'")
    private BigDecimal taxAmt;

    @Column(name = "tax_cur_amt", columnDefinition = "decimal(18,8) comment '税额(本位币)'")
    private BigDecimal taxCurAmt;

    @Column(name = "excl_tax_amt", columnDefinition = "decimal(18,8) comment '不含税总金额'")
    private BigDecimal exclTaxAmt;

    @Column(name = "excl_tax_cur_amt", columnDefinition = "decimal(18,8) comment '不含税总金额(本位币)'")
    private BigDecimal exclTaxCurAmt;

    @Column(name = "inv_type", columnDefinition = "varchar(20) comment '发票类型'")
    private String invType;

    @Column(name = "inv_kind", columnDefinition = "varchar(20) comment '红/蓝票'")
    private String invKind;

    @Column(name = "exam_type", columnDefinition = "varchar(20) comment '查验状态'")
    private String examType;



    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SaleInvDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SaleInvDtlDO entity = (SaleInvDtlDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}