package com.elitesland.yst.production.fin.entity.picturefile;

import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import com.elitescloud.boot.model.entity.BaseModel;
import java.util.Objects;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.Where;

/**
 * @author : http://www.chiner.pro
 * @date : 2023-2-20
 * @desc : 图片信息
 */
@Entity
@Table(name="picture_file")
@org.hibernate.annotations.Table(appliesTo = "picture_file", comment = "图片信息")
@Data
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0")
public class PictureFileDO extends BaseModel{

    @Column(name = "url", columnDefinition = "varchar(255) comment '图片链接'")
    private String url;

    @Column(name = "code", columnDefinition = "varchar(255) comment '编码'")
    private String code;

    @Column(name = "source_id", columnDefinition = "bigint(20) comment '来源id'")
    private Long sourceId;

    @Column(name = "source_type", columnDefinition = "varchar(255) comment '来源类型'")
    private String sourceType;

    @Column(name = "file_name", columnDefinition = "varchar(255) comment '文件名称'")
    private String fileName;

    @Column(name = "old_file_name", columnDefinition = "varchar(255) comment '原始文件名称'")
    private String oldFileName;

    @Column(name = "file_size", columnDefinition = "varchar(255) comment '文件大小'")
    private String fileSize;

    @Column(name = "file_info", columnDefinition = "varchar(255) comment '文件内容'")
    private String fileInfo;

}