package com.elitesland.yst.production.fin.infr.repo.apverconfig;


import com.elitesland.yst.production.fin.domain.entity.apverconfig.QApVerConfigDtlDO;
import com.elitesland.yst.production.fin.infr.dto.apverconfig.ApVerConfigDtlDTO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/6 16:48
 */
@Component
@RequiredArgsConstructor
public class ApVerConfigDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QApVerConfigDtlDO qApVerConfigDtlDO = QApVerConfigDtlDO.apVerConfigDtlDO;


    public List<ApVerConfigDtlDTO> queryByMasId(Long masId) {
        return select(ApVerConfigDtlDTO.class)
                .where(qApVerConfigDtlDO.masId.eq(masId))
                .fetch();
    }

    public List<ApVerConfigDtlDTO> queryNoMasId() {
        return select(ApVerConfigDtlDTO.class)
                .where(qApVerConfigDtlDO.masId.isNull())
                .where(qApVerConfigDtlDO.deleteFlag.eq(0))
                .fetch();
    }

    public void deleteByMasId(Long masId) {
        jpaQueryFactory.delete(qApVerConfigDtlDO)
                .where(qApVerConfigDtlDO.masId.eq(masId))
                .execute();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qApVerConfigDtlDO.id,
                qApVerConfigDtlDO.masId,
                qApVerConfigDtlDO.fieldNo,
                qApVerConfigDtlDO.fieldName,
                qApVerConfigDtlDO.fieldType,
                qApVerConfigDtlDO.editFlag,
                qApVerConfigDtlDO.matchFlag,
                qApVerConfigDtlDO.remark,
                qApVerConfigDtlDO.createTime,
                qApVerConfigDtlDO.creator,
                qApVerConfigDtlDO.modifyTime,
                qApVerConfigDtlDO.modifyUserId,
                qApVerConfigDtlDO.updater)
        ).from(qApVerConfigDtlDO);
    }
}
