/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.fin.application.service.artype;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.fin.application.convert.artype.ArTypeConvert;
import com.elitesland.yst.production.fin.application.facade.param.artype.ArTypeParam;
import com.elitesland.yst.production.fin.application.facade.vo.artype.ArTypeVO;
import com.elitesland.yst.production.fin.application.service.artype.ArTypeService;
import com.elitesland.yst.production.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.yst.production.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.yst.production.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.yst.production.fin.domain.service.artype.ArTypeOuDomainService;
import com.elitesland.yst.production.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.yst.production.fin.infr.dto.artype.ArTypeOuDTO;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ArTypeServiceImpl
implements ArTypeService {
    private final ArTypeDomainService arTypeDomainService;
    private final ArTypeOuDomainService arTypeOuDomainService;
    private final ArOrderDomainService arOrderDomainService;

    @Override
    public ApiResult<Long> save(ArTypeParam arTypeParam) {
        Long res = this.arTypeDomainService.save(ArTypeConvert.INSTANCE.convert(arTypeParam));
        return ApiResult.ok((Object)res);
    }

    @Override
    public ApiResult<Long> update(ArTypeParam arTypeParam) {
        if (null == arTypeParam.getId()) {
            throw new BusinessException("\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long res = this.arTypeDomainService.update(ArTypeConvert.INSTANCE.convert(arTypeParam));
        return ApiResult.ok((Object)res);
    }

    @Override
    public ApiResult<ArTypeVO> get(Long id) {
        ArTypeDTO res = this.arTypeDomainService.get(id);
        return ApiResult.ok((Object)ArTypeConvert.INSTANCE.convert(res));
    }

    @Override
    public ApiResult<PagingVO<ArTypeVO>> page(ArTypePageParam arTypePageParam) {
        PagingVO<ArTypeDTO> res = this.arTypeDomainService.page(arTypePageParam);
        return ApiResult.ok(ArTypeConvert.INSTANCE.convertPage(res));
    }

    @Override
    public ApiResult<Boolean> updateEnableFlag(List<Long> ids, boolean enable) {
        List<ArTypeDTO> arTypeDTOS = this.arTypeDomainService.findByIds(ids);
        if (enable) {
            this.checkEnableRule(arTypeDTOS);
        }
        if (!enable) {
            this.checkStopRule(arTypeDTOS);
        }
        Boolean res = this.arTypeDomainService.updateEnableFlag(ids, enable);
        return ApiResult.ok((Object)res);
    }

    @Override
    public ApiResult<Long> updateDef(Long id) {
        Long res = this.arTypeDomainService.updateDef(id);
        return ApiResult.ok((Object)res);
    }

    @Override
    public ApiResult<Long> del(Long id) {
        List<ArTypeOuDTO> arTypeOuDTOS = this.arTypeOuDomainService.queryByArTypeId(id);
        if (CollUtil.isNotEmpty(arTypeOuDTOS)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u6570\u636e\u5df2\u5206\u914d\u516c\u53f8!");
        }
        Boolean aBoolean = this.arOrderDomainService.queryByArTypeId(id);
        if (aBoolean.booleanValue()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8be5\u6570\u636e\u5df2\u5173\u8054\u5e94\u6536\u5355!");
        }
        Long res = this.arTypeDomainService.del(id);
        return ApiResult.ok((Object)res);
    }

    @Override
    public ApiResult<List<ArTypeVO>> getList() {
        List<ArTypeDTO> res = this.arTypeDomainService.getList();
        return ApiResult.ok(ArTypeConvert.INSTANCE.convertList(res));
    }

    @Override
    public ApiResult<ArTypeVO> getDef() {
        ArTypeDTO res = this.arTypeDomainService.getDef();
        if (res == null) {
            return ApiResult.ok((Object)new ArTypeVO());
        }
        return ApiResult.ok((Object)ArTypeConvert.INSTANCE.convert(res));
    }

    private void checkStopRule(List<ArTypeDTO> arTypeDTOS) {
        for (ArTypeDTO arTypeDTO : arTypeDTOS) {
            if (arTypeDTO.getEnableFlag().booleanValue()) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u505c\u7528\u72b6\u6001\u4e0d\u80fd\u518d\u505c\u7528");
        }
    }

    private void checkEnableRule(List<ArTypeDTO> arTypeDTOS) {
        for (ArTypeDTO arTypeDTO : arTypeDTOS) {
            if (arTypeDTO.getEnableFlag().booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u518d\u542f\u52a8");
            }
            List<ArTypeOuDTO> arTypeOuDTOS = this.arTypeOuDomainService.queryByArTypeId(arTypeDTO.getId());
            if (!CollUtil.isEmpty(arTypeOuDTOS)) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7c7b\u578b\u4ee3\u7801" + arTypeDTO.getArTypeCode() + "\u542f\u7528\u524d\u9700\u8981\u5206\u914d\u516c\u53f8");
        }
    }

    public ArTypeServiceImpl(ArTypeDomainService arTypeDomainService, ArTypeOuDomainService arTypeOuDomainService, ArOrderDomainService arOrderDomainService) {
        this.arTypeDomainService = arTypeDomainService;
        this.arTypeOuDomainService = arTypeOuDomainService;
        this.arOrderDomainService = arOrderDomainService;
    }
}

