package com.elitesland.yst.production.fin.application.convert.arverconfig;
import com.elitesland.yst.production.fin.application.facade.param.arverconfig.ArVerConfigSaveParam;
import com.elitesland.yst.production.fin.application.facade.vo.arverconfig.ArVerConfigVO;
import com.elitesland.yst.production.fin.domain.entity.arverconfig.ArVerConfig;
import com.elitesland.yst.production.fin.domain.entity.arverconfig.ArVerConfigDO;
import com.elitesland.yst.production.fin.infr.dto.arverconfig.ArVerConfigDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/25 15:16
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface ArVerConfigConvert {
    ArVerConfigConvert INSTANCE = Mappers.getMapper(ArVerConfigConvert.class);

    @Mapping(source = "arVerConfigDtlSaveParams", target = "configDtlList")
    ArVerConfig paramConvert(ArVerConfigSaveParam param);

    ArVerConfigDO convert(ArVerConfig apverConfig);

    @Mapping(source = "arVerConfigDtlDTOS", target = "arVerConfigDtlVOS")
    ArVerConfigVO convertVo(ArVerConfigDTO apVerConfigDTO);

    PagingVO<ArVerConfigVO> convertPage(PagingVO<ArVerConfigDTO> pagingVO);

    List<ArVerConfigVO> dtoToVo(List<ArVerConfigDTO> dtoList);

}
