package com.elitesland.yst.production.fin.application.facade.param.apverrec;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-4-22
 * @desc : 应付核销记录明细
 */
@Data
public class ApVerRecDtlParam implements Serializable {

    private static final long serialVersionUID = 5374564367175223582L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("总单ID")
    private Long masId;

    @ApiModelProperty("核销编号")
    private String verNo;

    @ApiModelProperty("核销日期")
    private LocalDateTime verDate;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("单据名称[应付单:付款单]")
    private String orderName;

    @ApiModelProperty("单据编号[应付单号:付款单号]")
    private String orderNo;

    @ApiModelProperty("单据类型[AP:PAY]")
    private String orderType;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("单据ID[应付单ID:付款单ID]")
    private Long orderId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("业务日期")
    private LocalDateTime buDate;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本次核销金额")
    private BigDecimal amt;

    @ApiModelProperty("核销方式")
    private String verifyType;

    @ApiModelProperty("核销方案编号")
    private String schemeNo;

    @ApiModelProperty("核销方案名称")
    private String schemeName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("核销方案ID")
    private Long schemeId;

}