package com.elitesland.yst.production.fin.application.service.cgorder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.fin.Application;
import com.elitesland.yst.production.fin.application.convert.cgorder.CgOrderConvert;
import com.elitesland.yst.production.fin.application.convert.picturefile.PictureFileConvert;
import com.elitesland.yst.production.fin.application.facade.param.cgorder.CgOrderPageParam;
import com.elitesland.yst.production.fin.application.facade.param.cgorder.CgOrderParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.yst.production.fin.application.facade.param.flow.SaveFlowParam;
import com.elitesland.yst.production.fin.application.facade.vo.account.AccountVO;
import com.elitesland.yst.production.fin.application.facade.vo.cgorder.CgOrderVO;
import com.elitesland.yst.production.fin.application.facade.vo.picturefile.PictureFileVO;
import com.elitesland.yst.production.fin.application.service.account.AccountService;
import com.elitesland.yst.production.fin.application.service.flow.AccountFlowService;
import com.elitesland.yst.production.fin.application.service.picturefile.PictureFileService;
import com.elitesland.yst.production.fin.common.FinConstant;
import com.elitesland.yst.production.fin.common.SysNumEnum;
import com.elitesland.yst.production.fin.common.SysNumberGenerator;
import com.elitesland.yst.production.fin.common.UdcEnum;
import com.elitesland.yst.production.fin.entity.cgorder.CgOrderDO;
import com.elitesland.yst.production.fin.entity.picturefile.PictureFileDO;
import com.elitesland.yst.production.fin.repo.cgorder.CgOrderRepo;
import com.elitesland.yst.production.fin.repo.cgorder.CgOrderRepoProc;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2023/2/17 14:35
 */
@Service
public class CgOrderServiceImpl implements CgOrderService {

    @Autowired
    private CgOrderRepo cgOrderRepo;
    @Autowired
    private CgOrderRepoProc cgOrderRepoProc;
    @Autowired
    private PictureFileService pictureFileService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private SysNumberGenerator sysNumberGenerator;

    @Autowired
    private UdcProvider udcProvider;

    @Autowired
    private  AccountFlowService accountFlowService;

    @SysCodeProc
    @Override
    public PagingVO<CgOrderVO> page(CgOrderPageParam cgOrderPageParam) {
        Map<String, String> cgType1 = udcProvider.getValueMapByUdcCode(Application.NAME, "CHARGE_ORDER_TYPE1");
        Map<String, String> cgType2 = udcProvider.getValueMapByUdcCode(Application.NAME, "CHARGE_ORDER_TYPE2");
        PagingVO<CgOrderVO> page = cgOrderRepoProc.page(cgOrderPageParam);
        List<Long> sourceIds = page.getRecords().stream().map(CgOrderVO::getId).collect(Collectors.toList());
        Map<Long, List<PictureFileVO>> pitMap = pictureFileService.queryBySourceIds(sourceIds).stream().collect(Collectors.groupingBy(PictureFileVO::getSourceId));
        page.getRecords().forEach(vo -> {
            if (pitMap.get(vo.getId()) != null) {
                vo.setPictureFileVOS(pitMap.get(vo.getId()));
            }
            if (!StringUtils.isEmpty(cgType1.get(vo.getCgType()))) {
                vo.setCgTypeName(cgType1.get(vo.getCgType()));
            }
            if (StringUtils.isEmpty(vo.getCgTypeName())) {
                if (!StringUtils.isEmpty(cgType2.get(vo.getCgType()))) {
                    vo.setCgTypeName(cgType2.get(vo.getCgType()));
                }
            }
        });
        return page;
    }

    @SysCodeProc
    @Override
    public CgOrderVO getOne(Long id) {
        Map<String, String> cgType1 = udcProvider.getValueMapByUdcCode(Application.NAME, "CHARGE_ORDER_TYPE1");
        Map<String, String> cgType2 = udcProvider.getValueMapByUdcCode(Application.NAME, "CHARGE_ORDER_TYPE2");
        CgOrderVO cgOrderVO = cgOrderRepoProc.queryById(id);
        List<PictureFileVO> pitList = pictureFileService.queryBySourceIds(List.of(id));
        cgOrderVO.setPictureFileVOS(pitList);
        if (!StringUtils.isEmpty(cgType1.get(cgOrderVO.getCgType()))) {
            cgOrderVO.setCgTypeName(cgType1.get(cgOrderVO.getCgType()));
        }
        if (StringUtils.isEmpty(cgOrderVO.getCgTypeName())) {
            if (!StringUtils.isEmpty(cgType2.get(cgOrderVO.getCgType()))) {
                cgOrderVO.setCgTypeName(cgType2.get(cgOrderVO.getCgType()));
            }
        }
        return cgOrderVO;
    }

   /* @Override
    public void export(CgOrderPageParam cgOrderPageParam, HttpServletResponse response) {
        PagingVO<CgOrderVO> page = cgOrderRepoProc.page(cgOrderPageParam);
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode("", "UTF-8").replace("+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            EasyExcelFactory.write(response.getOutputStream(), CgOrderVO.class).sheet("").doWrite(page.getRecords());
        } catch (IOException e) {
            throw new BusinessException("导出失败!");
        }
    }*/

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> approve(List<Long> ids) {
        List<CgOrderVO> cgOrderVO = cgOrderRepoProc.queryByIds(ids);
        cgOrderVO.forEach(vo -> {
            if (!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode())) {
                throw new BusinessException("只有审批中状态单据才可审批!");
            }
        });
        SysUserDTO user = getUser();
        cgOrderRepoProc.updateByIds(ids, UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode(), user);
        //处理流水
        if(!CollectionUtils.isEmpty(cgOrderVO)){
            CgOrderVO cgOrderVO1 = cgOrderVO.get(0);
            SaveFlowParam saveFlowParam = VoToFlowParam(cgOrderVO1,FinConstant.APPROVED);
            saveFlow(saveFlowParam);
        }
        return ids;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> reject(CgOrderParam cgOrderParam) {
        List<CgOrderVO> cgOrderVO = cgOrderRepoProc.queryByIds(cgOrderParam.getIds());
        cgOrderVO.forEach(vo -> {
            if (!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode())) {
                throw new BusinessException("只有审批中状态单据才可拒绝!");
            }
        });
        SysUserDTO user = getUser();
        cgOrderRepoProc.updateByReject(cgOrderParam.getIds(), UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode(), user,cgOrderParam.getAuditRejectReason());
        //如果是有来源的退款单
        if (!CollectionUtils.isEmpty(cgOrderVO)) {
            CgOrderVO cgOrderVO1 = cgOrderVO.get(0);
            if (cgOrderVO1.getSourceId() != null) {
                CgOrderVO cgOrderVO2 = cgOrderRepoProc.queryById(cgOrderVO1.getSourceId());
                BigDecimal unReturnAmt = cgOrderVO2.getUnrefundAmt().add(cgOrderVO1.getTotalAmt());
                BigDecimal returnAmt = cgOrderVO2.getRefundAmt().subtract(cgOrderVO1.getTotalAmt());
                //更新本身单据的已退款未退款金额
                cgOrderRepoProc.updateAmtById(cgOrderVO1.getSourceId(), unReturnAmt, returnAmt);
            }
        }
        if(!CollectionUtils.isEmpty(cgOrderVO)){
            CgOrderVO cgOrderVO1 = cgOrderVO.get(0);
            SaveFlowParam saveFlowParam = VoToFlowParam(cgOrderVO1, FinConstant.REJECT);
            saveFlow(saveFlowParam);
        }
        return cgOrderParam.getIds();
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> cancel(List<Long> ids) {
        List<CgOrderVO> cgOrderVO = cgOrderRepoProc.queryByIds(ids);
        cgOrderVO.forEach(vo -> {
            if (!vo.getState().equals(UdcEnum.COM_APPLY_STATUS_REJECTED.getValueCode())) {
                throw new BusinessException("只有审批拒绝状态单据才可作废!");
            }
        });
        SysUserDTO user = getUser();
        cgOrderRepoProc.updateByIds(ids, UdcEnum.COM_APPLY_STATUS_VOID.getValueCode(), user);
        return ids;
    }
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public Long returnCg(CgOrderParam cgOrderParam) {
        CgOrderVO cgOrderVO = cgOrderRepoProc.queryById(cgOrderParam.getId());
        if (!cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0001.getValueCode()) &&
                !cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0002.getValueCode()) &&
                !cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0003.getValueCode()) &&
                !cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0004.getValueCode()) &&
                !cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0005.getValueCode()) &&
                !cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0006.getValueCode()) &&
                !cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0007.getValueCode()) &&
                !cgOrderVO.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0008.getValueCode())) {
            throw new BusinessException("只能退还保证金类型单据!");
        }
        if (!cgOrderVO.getState().equals(UdcEnum.COM_APPLY_STATUS_COMPLETE.getValueCode())) {
            throw new BusinessException("只能退还已审批的单据!");
        }
        //处理自身退还逻辑
        if (cgOrderParam.getReturnAmt().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("退款金额必须大于0!");
        }
        if (cgOrderParam.getReturnAmt().compareTo(cgOrderVO.getUnrefundAmt()) > 0) {
            throw new BusinessException("退款金额大于未退款金额!");
        }
        BigDecimal unReturnAmt = cgOrderVO.getUnrefundAmt().subtract(cgOrderParam.getReturnAmt());
        BigDecimal returnAmt = cgOrderVO.getRefundAmt().add(cgOrderParam.getReturnAmt());
        //更新本身单据的已退款未退款金额
        cgOrderRepoProc.updateAmtById(cgOrderParam.getId(), unReturnAmt, returnAmt);
        CgOrderDO cgOrderDO = CgOrderConvert.INSTANCE.voToDo(cgOrderVO);
        cgOrderDO.setAuditRejectReason(null);
        cgOrderDO.setAuditTime(null);
        cgOrderDO.setAuditUserId(null);
        cgOrderDO.setAuditUser(null);
        cgOrderDO.setState(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode());
        String type = returnType(cgOrderVO.getType());
        cgOrderDO.setType(type);
        cgOrderDO.setCgType(getCgType(cgOrderDO.getType()));
        String docNo = sysNumberGenerator.generate(SysNumEnum.FIN_CG_ORDER.getCode());
        cgOrderDO.setDocNo(docNo);
        cgOrderDO.setTotalAmt(cgOrderParam.getReturnAmt());
        cgOrderDO.setSourceNo(cgOrderVO.getDocNo());
        cgOrderDO.setSourceId(cgOrderVO.getId());
        cgOrderDO.setRemark(cgOrderVO.getRemark());
        cgOrderDO.setCreateTime(LocalDateTime.now());
        cgOrderDO.setId(null);
        cgOrderDO.setRefundAmt(BigDecimal.ZERO);
        cgOrderDO.setUnrefundAmt(BigDecimal.ZERO);
        CgOrderDO save = cgOrderRepo.save(cgOrderDO);
       /* //处理流水
        SaveFlowParam saveFlowParam = DoToFlowParam(save, FinConstant.SUBMIT);
        saveFlow(saveFlowParam);*/
        //处理图片
        List<PictureFileVO> fileVOS = pictureFileService.queryBySourceIds(List.of(cgOrderParam.getId()));
        List<PictureFileDO> pictureFileDOS = PictureFileConvert.INSTANCE.voToDo(fileVOS);
        //新增逻辑
        pictureFileDOS.forEach(vo -> {
            vo.setSourceId(save.getId());
            vo.setSourceType(FinConstant.CG_ORDER);
            vo.setId(null);
        });
        pictureFileService.saveAll(pictureFileDOS);
        return save.getId();
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public Long save(CgOrderParam cgOrderParam) {
        checkSave(cgOrderParam);
        String cgType = cgOrderParam.getCgType();
        String type1 = cgOrderParam.getType();
        if (!StringUtils.isEmpty(type1)) {
            cgType = getCgType(type1);
        }
        if (StringUtils.isEmpty(type1) && !StringUtils.isEmpty(cgType)) {
            type1 = getType(cgType);
        }
        cgOrderParam.setCgType(cgType);
        cgOrderParam.setType(type1);
        //若是选择收款方式=账户扣款的保证金收款单，需要增加校验金额与经销商下全部整车储值账户可用金额的大小，若不满足提示余额不足，
        if ((cgOrderParam.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0005.getValueCode()) ||
                cgOrderParam.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0006.getValueCode()) ||
                cgOrderParam.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0007.getValueCode()) ||
                cgOrderParam.getType().equals(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0008.getValueCode()))) {
            List<AccountVO> accountVOS = accountService.queryAccount(List.of(cgOrderParam.getAccCode()), null, UdcEnum.FIN_ENABLE_STATE_ENABLE.getValueCode());
            BigDecimal avaAmt = accountVOS.stream().map(AccountVO::getAccAvaAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (cgOrderParam.getTotalAmt().compareTo(avaAmt) > 0) {
                throw new BusinessException("已启用的储值账户余额不足,请检查!");
            }
        }
        CgOrderDO cgOrderDO = CgOrderConvert.INSTANCE.paramToDo(cgOrderParam);
        cgOrderDO.setUnrefundAmt(cgOrderDO.getTotalAmt());
        cgOrderDO.setRefundAmt(BigDecimal.ZERO);
        if (cgOrderParam.getId() == null) {
            String docNo = sysNumberGenerator.generate(SysNumEnum.FIN_CG_ORDER.getCode());
            cgOrderDO.setDocNo(docNo);
        }
        CgOrderDO save = cgOrderRepo.save(cgOrderDO);
        if(save.getState().equals(UdcEnum.COM_APPLY_STATUS_DOING.getValueCode())){
            SaveFlowParam saveFlowParam = DoToFlowParam(save, FinConstant.SUBMIT);
            saveFlow(saveFlowParam);
        }
        List<PictureFileDO> pictureFileDOS = PictureFileConvert.INSTANCE.paramToDo(cgOrderParam.getImgs());
        if (cgOrderParam.getId() != null) {
            //先删除图片数据
            pictureFileService.deleteBySourceId(List.of(save.getId()));
        }
        //新增逻辑
        pictureFileDOS.forEach(vo -> {
            vo.setSourceId(save.getId());
            vo.setSourceType(FinConstant.CG_ORDER);
        });
        pictureFileService.saveAll(pictureFileDOS);
        return save.getId();
    }

    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("当前登陆人信息获取为空!");
        }
        return userDetails.getUser();
    }
    private String returnType(String type){
        //充值和账户扣款的装修保证金，退款的时候就退到装修保证金退款单。
        // 充值和账户扣款的新品保证金，退款就退到新品保证进行退款单。
        // 然后充值和账户扣款的电池保证金退款就退到。电池保证金退款单。
        // 充值和账户扣款的定制品保证金退款就定制品保证金退款单
        switch (type) {
            case FinConstant.BZJ0001:
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0001.getValueCode();
            case FinConstant.BZJ0002:
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0001.getValueCode();
            case FinConstant.BZJ0003:
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0003.getValueCode();
            case FinConstant.BZJ0004:
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0003.getValueCode();
            case FinConstant.BZJ0005:
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0004.getValueCode();
            case FinConstant.BZJ0006:
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0004.getValueCode();
            case FinConstant.BZJ0007:
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0002.getValueCode();
            case FinConstant.BZJ0008:
                return UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0002.getValueCode();
            default:
                throw new BusinessException("获取单据类型失败");
        }
    }
    @Override
    public String getCgType(String type) {
        String cgType = "";
        switch (type) {
            case FinConstant.ZC0001:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_ZCCZ.getValueCode();
                break;
            case FinConstant.PJ0001:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_PJCZ.getValueCode();
                break;
            case FinConstant.FJ0001:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_FJBCZ.getValueCode();
                break;
            case FinConstant.BZJ0004:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_DCBZJ.getValueCode();
                break;
            case FinConstant.BZJ0005:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_DCBZJ.getValueCode();
                break;
            case FinConstant.BZJ0001:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_ZXBZJ.getValueCode();
                break;
            case FinConstant.BZJ0006:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_ZXBZJ.getValueCode();
                break;
            case FinConstant.BZJ0002:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_DZPBZJ.getValueCode();
                break;
            case FinConstant.BZJ0007:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_DZPBZJ.getValueCode();
                break;
            case FinConstant.BZJ0003:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_XPBZJ.getValueCode();
                break;
            case FinConstant.BZJ0008:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE1_XPBZJ.getValueCode();
                break;
            case FinConstant.RBZJ0001:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE2_ZXBZJT.getValueCode();
                break;
            case FinConstant.RBZJ0002:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE2_DZPBZJT.getValueCode();
                break;
            case FinConstant.RBZJ0003:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE2_XPBZJT.getValueCode();
                break;
            case FinConstant.RBZJ0004:
                cgType = UdcEnum.FIN_CHARGE_ORDER_TYPE2_DCBZJT.getValueCode();
                break;
            default:
                throw new BusinessException("获取充值类型失败");
        }
        return cgType;
    }

    @Override
    public String getType(String cgType) {
        String type = "";
        //标产后续设计可能根据收款方式再拆分单据
        switch (cgType) {
            case FinConstant.ZCCZ:
                type = UdcEnum.FIN_CG_ORDER_TYPE_ZC0001.getValueCode();
                break;
            case FinConstant.PJCZ:
                type = UdcEnum.FIN_CG_ORDER_TYPE_PJ0001.getValueCode();
                break;
            case FinConstant.FJBCZ:
                type = UdcEnum.FIN_CG_ORDER_TYPE_FJ0001.getValueCode();
                break;
            case FinConstant.DCBZJ:
                type = UdcEnum.FIN_CG_ORDER_TYPE_BZJ0004.getValueCode();
                break;
            case FinConstant.ZXBZJ:
                type = UdcEnum.FIN_CG_ORDER_TYPE_BZJ0001.getValueCode();
                break;
            case FinConstant.DZPBZJ:
                type = UdcEnum.FIN_CG_ORDER_TYPE_BZJ0002.getValueCode();
                break;
            case FinConstant.XPBZJ:
                type = UdcEnum.FIN_CG_ORDER_TYPE_BZJ0003.getValueCode();
                break;
            case FinConstant.ZXBZJT:
                type = UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0001.getValueCode();
                break;
            case FinConstant.DZPBZJT:
                type = UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0002.getValueCode();
                break;
            case FinConstant.XPBZJT:
                type = UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0003.getValueCode();
                break;
            case FinConstant.DCBZJT:
                type = UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0004.getValueCode();
                break;
            default:
                throw new BusinessException("获取单据类型失败");
        }
        return type;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public List<Long> delete(List<Long> ids) {
        cgOrderRepoProc.updateDel(ids);
        return ids;
    }

    @Override
    public BigDecimal queryByUserId(CgOrderParam cgOrderParam) {
        List<String> types=new ArrayList<>();
        List<String> typesT=new ArrayList<>();
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0001.getValueCode());
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0002.getValueCode());
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0003.getValueCode());
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0004.getValueCode());
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0005.getValueCode());
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0006.getValueCode());
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0007.getValueCode());
        types.add(UdcEnum.FIN_CG_ORDER_TYPE_BZJ0008.getValueCode());
        typesT.add(UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0001.getValueCode());
        typesT.add(UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0002.getValueCode());
        typesT.add(UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0003.getValueCode());
        typesT.add(UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0004.getValueCode());
        cgOrderParam.setState(UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode());
        BigDecimal totalAmt = cgOrderRepoProc.queryAmountSum(cgOrderParam, types);
        BigDecimal totalAmtT = cgOrderRepoProc.queryAmountSum(cgOrderParam, typesT);
        totalAmt= totalAmt==null?BigDecimal.ZERO:totalAmt;
        totalAmtT= totalAmtT==null?BigDecimal.ZERO:totalAmtT;
        return totalAmt.subtract(totalAmtT);
    }

    private void checkSave(CgOrderParam cgOrderParam) {
        Assert.notEmpty(cgOrderParam.getRecType(), "收款方式不能为空!");
        Assert.notEmpty(cgOrderParam.getRecBankAcc(), "收款账号不能为空!");
        Assert.notEmpty(cgOrderParam.getAccName(), "账户名称不能为空!");
        Assert.notEmpty(cgOrderParam.getAccCode(), "账户编码不能为空!");
        Assert.notEmpty(cgOrderParam.getAccType(), "账户类型不能为空!");
        Assert.notNull(cgOrderParam.getTotalAmt(), "金额不能为空!");
        Assert.notNull(cgOrderParam.getCgTime(), "汇款日期不能为空!");
        Assert.notEmpty(cgOrderParam.getType(), "单据类型不能为空!");
        Assert.notNull(cgOrderParam.getImgs(), "图片信息不能为空!");
        if (cgOrderParam.getTotalAmt().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("金额不能小于等于0!");
        }
    }

    private void saveFlow(SaveFlowParam saveFlowParam) {
        List<AccountFlowParam> param = new ArrayList<>();
        AccountFlowParam accountFlowParam = new AccountFlowParam();
        accountFlowParam.setAmount(saveFlowParam.getTotalAmt());
        accountFlowParam.setAccCode(saveFlowParam.getAccCode());
        accountFlowParam.setAccName(saveFlowParam.getAccName());
        accountFlowParam.setSourceNo(saveFlowParam.getDocNo());
        accountFlowParam.setSourceDoc(UdcEnum.FIN_SOURCE_DOC_TYPE_RECEIPT.getValueCode());
        accountFlowParam.setAccType(saveFlowParam.getAccType());
        accountFlowParam.setTransactionTime(saveFlowParam.getTime());
        accountFlowParam.setSourcePlatform(UdcEnum.FIN_SOURCE_PLATFORM_TYPE_FIN.getValueCode());
        String transactionType="";
        String dataSource="";
        //整车 整车收款单审核通过
        if((UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode().equals(saveFlowParam.getAccType())||UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode().equals(saveFlowParam.getAccType()))&&
                UdcEnum.FIN_CG_ORDER_TYPE_ZC0001.getValueCode().equals(saveFlowParam.getType())&&FinConstant.APPROVED.equals(saveFlowParam.getScene())){
            transactionType=UdcEnum.FIN_TRANSACTION_TYPE_CZ.getValueCode();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_SKD01.getValueCode();
        //提交账户扣款的保证金
        }else if((UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode().equals(saveFlowParam.getAccType())||UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode().equals(saveFlowParam.getAccType()))&&
                (UdcEnum.FIN_CG_ORDER_TYPE_BZJ0005.getValueCode().equals(saveFlowParam.getType())||UdcEnum.FIN_CG_ORDER_TYPE_BZJ0006.getValueCode().equals(saveFlowParam.getType())
                ||UdcEnum.FIN_CG_ORDER_TYPE_BZJ0007.getValueCode().equals(saveFlowParam.getType())||UdcEnum.FIN_CG_ORDER_TYPE_BZJ0008.getValueCode().equals(saveFlowParam.getType())
                )&&FinConstant.SUBMIT.equals(saveFlowParam.getScene())){
            transactionType=UdcEnum.FIN_TRANSACTION_TYPE_BZJZY.getValueCode();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_BZJ01.getValueCode();
            //收款方式=账户扣款的保证金收款单审核拒绝
        }else if((UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode().equals(saveFlowParam.getAccType())||UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode().equals(saveFlowParam.getAccType()))&&
                (UdcEnum.FIN_CG_ORDER_TYPE_BZJ0005.getValueCode().equals(saveFlowParam.getType())||UdcEnum.FIN_CG_ORDER_TYPE_BZJ0006.getValueCode().equals(saveFlowParam.getType())
                        ||UdcEnum.FIN_CG_ORDER_TYPE_BZJ0007.getValueCode().equals(saveFlowParam.getType())||UdcEnum.FIN_CG_ORDER_TYPE_BZJ0008.getValueCode().equals(saveFlowParam.getType()))
                &&FinConstant.REJECT.equals(saveFlowParam.getScene())){
            transactionType=UdcEnum.FIN_TRANSACTION_TYPE_BZJSF.getValueCode();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_BZJ02.getValueCode();
            //收款方式=账户扣款的保证金收款单审核通过
        } else if((UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode().equals(saveFlowParam.getAccType())||UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode().equals(saveFlowParam.getAccType()))&&
                (UdcEnum.FIN_CG_ORDER_TYPE_BZJ0005.getValueCode().equals(saveFlowParam.getType())||UdcEnum.FIN_CG_ORDER_TYPE_BZJ0006.getValueCode().equals(saveFlowParam.getType())
                        ||UdcEnum.FIN_CG_ORDER_TYPE_BZJ0007.getValueCode().equals(saveFlowParam.getType())||UdcEnum.FIN_CG_ORDER_TYPE_BZJ0008.getValueCode().equals(saveFlowParam.getType()))
                &&FinConstant.APPROVED.equals(saveFlowParam.getScene())){
            transactionType=UdcEnum.FIN_TRANSACTION_TYPE_BZJKK.getValueCode();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_BZJ03.getValueCode();
            //保证金退款单审核通过
        } else if((UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode().equals(saveFlowParam.getAccType())||UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode().equals(saveFlowParam.getAccType()))&&
                (UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0001.getValueCode().equals(saveFlowParam.getType())||UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0002.getValueCode().equals(saveFlowParam.getType())
                        ||UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0003.getValueCode().equals(saveFlowParam.getType())||UdcEnum.FIN_CG_ORDER_TYPE_RBZJ0004.getValueCode().equals(saveFlowParam.getType()))
                &&FinConstant.APPROVED.equals(saveFlowParam.getScene())) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_BZJTK.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_BZJ04.getValueCode();
            //配件储值账户 配件收款单审核通过
        }else if(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode().equals(saveFlowParam.getAccType())&&UdcEnum.FIN_CG_ORDER_TYPE_PJ0001.getValueCode().equals(saveFlowParam.getType())&&
                FinConstant.APPROVED.equals(saveFlowParam.getScene())){
            transactionType=UdcEnum.FIN_TRANSACTION_TYPE_CZ.getValueCode();
            dataSource=UdcEnum.FIN_DATA_SOURCE_TYPE_SKD01.getValueCode();
            //附件包储值账户
        } else if(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode().equals(saveFlowParam.getAccType())&&UdcEnum.FIN_CG_ORDER_TYPE_FJ0001.getValueCode().equals(saveFlowParam.getType())
                &&FinConstant.APPROVED.equals(saveFlowParam.getScene())){
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_CZ.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_SKD01.getValueCode();
        }
        accountFlowParam.setTransactionType(transactionType);
        accountFlowParam.setDataSource(dataSource);
        param.add(accountFlowParam);
        if (!StringUtils.isEmpty(transactionType) && !StringUtils.isEmpty(dataSource)) {
            accountFlowService.save(param);
        }
    }

    private SaveFlowParam VoToFlowParam(CgOrderVO cgOrderVO1, String sence) {
        SaveFlowParam saveFlowParam = new SaveFlowParam();
        saveFlowParam.setAccType(cgOrderVO1.getAccType());
        saveFlowParam.setTotalAmt(cgOrderVO1.getTotalAmt());
        saveFlowParam.setAccCode(cgOrderVO1.getAccCode());
        saveFlowParam.setAccType(cgOrderVO1.getAccType());
        saveFlowParam.setAccName(cgOrderVO1.getAccName());
        saveFlowParam.setDocNo(cgOrderVO1.getDocNo());
        saveFlowParam.setTime(LocalDateTime.now());
        saveFlowParam.setType(cgOrderVO1.getType());
        saveFlowParam.setScene(sence);
        return saveFlowParam;
    }

    private SaveFlowParam DoToFlowParam(CgOrderDO save, String sence) {
        SaveFlowParam saveFlowParam = new SaveFlowParam();
        saveFlowParam.setAccType(save.getAccType());
        saveFlowParam.setTotalAmt(save.getTotalAmt());
        saveFlowParam.setAccCode(save.getAccCode());
        saveFlowParam.setAccName(save.getAccName());
        saveFlowParam.setAccType(save.getAccType());
        saveFlowParam.setDocNo(save.getDocNo());
        saveFlowParam.setTime(LocalDateTime.now());
        saveFlowParam.setType(save.getType());
        saveFlowParam.setScene(sence);
        return saveFlowParam;
    }
}
