package com.elitesland.yst.production.fin.application.service.recorder;

import com.elitesland.yst.production.fin.application.convert.recorder.RecOrderDtlConvert;
import com.elitesland.yst.production.fin.application.facade.vo.recorder.RecOrderDtlVO;
import com.elitesland.yst.production.fin.domain.param.recorder.RecOrderDtlPageParam;
import com.elitesland.yst.production.fin.domain.service.recorder.RecOrderDtlDomainService;
import com.elitesland.yst.production.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @author zhiyu.he
 * @date 2022/4/13 11:43
 */
@Service
@RequiredArgsConstructor
public class RecOrderDtlServiceImpl implements RecOrderDtlService {
    private final RecOrderDtlDomainService recOrderDtlDomainService;

    @SysCodeProc
    @Override
    public PagingVO<RecOrderDtlVO> page(RecOrderDtlPageParam param) {
        PagingVO<RecOrderDtlDTO> page = recOrderDtlDomainService.page(param);
        PagingVO<RecOrderDtlVO> recOrderDtlVOPagingVO = RecOrderDtlConvert.INSTANCE.convertPage(page);
        return recOrderDtlVOPagingVO;
    }
}
