package com.elitesland.yst.production.fin.application.web.workflow;

import com.elitescloud.boot.wrapper.Isolatable;
import com.elitesland.yst.production.fin.application.service.workflow.saleinv.SaleInvProcessService;
import com.elitesland.yst.production.fin.common.CallBackPathConstant;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;


@Slf4j
@RequiredArgsConstructor
@RestController
@RequestMapping(CallBackPathConstant.FIN_SALE_INV_PATH)
public class FinSaleInvController implements WorkflowCallBack {

    private final Isolatable isolatable;
    private final SaleInvProcessService saleInvProcessService;
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人:{}", payload.toString());
        try {
            return (ArrayList<String>)isolatable.apply(()->{
                ArrayList<String> resultList = new ArrayList<>();
                if (StringUtils.isNotEmpty(payload.getCustomParams())) {
                    resultList = saleInvProcessService.taskAssignee(payload.getBusinessKey(),
                            payload.getCustomParams());
                }
                return resultList;
            },payload.getTenantId());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

    }

    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调:{}",payload.toString());
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调:{}",payload.toString());
    }

    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("状态修改回调:{}",payload.toString());
        saleInvProcessService.processStatusChange(Long.parseLong(payload.getBusinessKey()), payload.getProcInstStatus(),
                payload.getCommentInfo());
    }
}
